package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.web.aware.ServletDispatcherAware;

/**
 * ServletDispatcher 객체를 주입합니다.
 *
 */
final class ServletDispatcherInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		try {
			((ServletDispatcherAware) action).setServletDispatcher(context.getDispatcher());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}