package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.web.aware.ParameterMapAware;

/**
 * 요청 파라미터를 맵으로 주입합니다.
 *
 */
final class ParameterMapInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation) throws InterceptorException {
		try {
			((ParameterMapAware) action).setParameter(context.getParameterMap());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}