package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.PropertyCopy;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;

/**
 * 요청 파라미터를 액션에 주입합니다.
 *
 */
public class ParameterInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		PropertyCopy.mapToBean(context.getParameterMap(), action);
	}
}
