package net.kldp.beat.message;

import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.Config;

public class ResourceManager {
	private String namespace;

	public ResourceManager(String namespace) {
		this.namespace = namespace;
		ResourcePool.add();
	}

	public void translate() {
		ActionMapping mapping = Config.getMapping(namespace);
		GetResource getResource = new GetResource(mapping);
		for (Resource resource : ResourcePool.getList()) {
			String message = getResource.get(resource.getKey());
			resource.getMessage().setMessage(message);
		}
	}

	@Override
	public void finalize() throws Throwable {
		super.finalize();
		ResourcePool.remove();
	}
}