package net.kldp.beat.message;

public class Resource {

	private static GetResource resource;
	private Message message = new Message();
	private String key;

	private Resource() {
		synchronized (this) {
			if (resource == null)
				resource = new GetResource();
		}
		ResourcePool.put(this);
	}

	public Resource(String key) {
		this();
		this.key = key;
		message.setMessage(resource.get(key));
	}

	public Resource(String key, Object... args) {
		this(key);
		message.setArgs(args);
	}

	@Override
	public String toString() {
		return message.toString();
	}

	Message getMessage() {
		return message;
	}

	String getKey() {
		return key;
	}
}