package net.kldp.beat.message;

public class Message {
	private String message;
	private Object[] args;

	protected Message() {
	}

	public Message(String message, Object... args) {
		this.message = message;
		this.args = args;
	}

	public final void setMessage(String message) {
		this.message = message;
	}

	public final void setArgs(Object... args) {
		this.args = args;
	}

	public final String toString() {
		return parseString();
	}

	public static final String format(String message, Object... args) {
		return new Message(message, args).toString();
	}

	private final String parseString() {
		if (args == null)
			return message;
		String message = this.message;
		for (int i = 0; i < args.length; i++) {
			message = message.replaceAll("\\{" + i + "\\}", args[i].toString());
		}
		return message;
	}
}