package net.kldp.beat.message;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.Config;

public class GetResource {

	private static List<Properties> properties = new ArrayList<Properties>();

	public GetResource(ActionMapping mapping) {
		for (String resource : mapping.getResources()) {
			try {
				Properties prop = new Properties();
				prop.load(mapping.getClass().getResourceAsStream(resource));
				properties.add(prop);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	public GetResource() {
		this(Config.defaultMapping());
	}

	public String get(String key) {
		Object value;
		for (Properties prop : properties) {
			value = prop.get(key);
			if (value != null)
				return (String) value;
		}
		return null;
	}
}