package net.kldp.beat.map;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Header를 Map으로 제공하기 위한 랩퍼 클래스입니다. 주의 : 헤더의 실제 적용은 Map객체를 수정하는것만으로 되지 않고, Map의
 * put메서드를 호출하여 쿠키를 삽입해야 합니다.
 */
public class HeaderMap extends AbstractMap<String, String> {

	private HttpServletResponse response;
	private HashMap<String, String> headers = new HashMap<String, String>();

	public HeaderMap(HttpServletRequest request, HttpServletResponse response) {
		putHeaders(request);
		this.response = response;
	}

	private void putHeaders(HttpServletRequest request) {
		Enumeration<?> enumeration = request.getHeaderNames();
		while (enumeration.hasMoreElements()) {
			String key = (String) enumeration.nextElement();
			String value = request.getHeader(key);
			headers.put(key, value);
		}
	}

	@Override
	String getAttribute(String key) {
		return headers.get(key);
	}

	@Override
	Enumeration<String> getAttributeNames() {
		return Collections.enumeration(headers.keySet());
	}

	@Override
	void removeAttribute(String key) {
		headers.remove(key);
		response.addHeader(key, "");
	}

	@Override
	void setAttribute(String key, String value) {
		headers.put(key, value);
		response.addHeader(key, value);
	}
}