package net.kldp.beat.map;

import java.util.Enumeration;
import java.util.Map;

import javax.servlet.ServletContext;

public class ApplicationMap extends AbstractMap<String, Object> implements Map<String, Object> {

	private ServletContext servletContext;

	public ApplicationMap(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	@SuppressWarnings("unchecked")
	@Override
	Enumeration<String> getAttributeNames() {
		return servletContext.getAttributeNames();
	}

	@Override
	void removeAttribute(String key) {
		servletContext.removeAttribute(key);
	}

	@Override
	Object getAttribute(String key) {
		return servletContext.getAttribute(key);
	}

	@Override
	void setAttribute(String key, Object value) {
		servletContext.setAttribute(key, value);
	}
}