package net.kldp.beat.interceptor.assemble;

import java.lang.annotation.Annotation;
import java.util.List;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.AnnotationFinder;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;

/**
 * 사용자 인터셉터를 저장하고 불러들이는 컨테이너 입니다.
 *
 */
public class UserInterceptorContainer {
	private Annotation annotation;
	private List<Annotation> systemAnnotations;
	private Class<? extends UserInterceptor> interceptor;

	public UserInterceptorContainer(Annotation annotation) throws ClassNotFoundException {
		this.annotation = annotation;
		this.interceptor = UserInterceptorClassPool.get(annotation);
		this.systemAnnotations = findSystemInterceptors();
	}

	/**
	 * 사용자 인터셉터에 사용된 시스템 인터셉터를 검색합니다.
	 * @return
	 */
	private List<Annotation> findSystemInterceptors() {
		AnnotationFinder finder;
		finder = new AnnotationFinder(interceptor);
		finder.find();
		return finder.getAnnotations();
	}

	/**
	 * 사용자 인터셉터의 어노테이션을 리턴합니다.
	 * @return
	 */
	public Annotation getAnnotatoin() {
		return annotation;
	}

	/**
	 * 사용자 인터셉터의 인터셉터 객체를 리턴합니다.
	 * @param context
	 * @return
	 * @throws InterceptorException
	 */
	public UserInterceptor getInterceptor(ActionContext context) throws InterceptorException {
		try {
			UserInterceptor instance = interceptor.newInstance();
			for (Annotation anno : systemAnnotations) {
				InterceptorFactory.intecept(instance, context, anno);
			}
			return instance;
		} catch (InstantiationException e) {
			throw new InterceptorException(e);
		} catch (IllegalAccessException e) {
			throw new InterceptorException(e);
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (interceptor == null)
			return false;
		if (obj instanceof UserInterceptorContainer) {
			UserInterceptorContainer container = (UserInterceptorContainer) obj;
			return interceptor.equals(container.interceptor);
		}
		return false;
	}

	@Override
	public int hashCode() {
		return 27;
	}
}