package net.kldp.beat.interceptor.assemble;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

import net.kldp.beat.interceptor.UserInterceptor;

/**
 * 사용자 인터셉터 클래스를 불러들이고 보관하는 클래스풀 입니다.
 * 
 */
public class UserInterceptorClassPool {
	private static Map<String, Class<? extends UserInterceptor>> interceptorClasses = new HashMap<String, Class<? extends UserInterceptor>>();

	/**
	 * 사용자 인터셉터 클래스를 불러들입니다.
	 * @param simpleName
	 * @return
	 * @throws ClassNotFoundException
	 */
	public static Class<? extends UserInterceptor> get(String simpleName) throws ClassNotFoundException {
		if (!interceptorClasses.containsKey(simpleName)) {
			addInterceptor(simpleName);
		}
		return interceptorClasses.get(simpleName);
	}

	/**
	 * 사용자 인터셉터 클래스를 불러들입니다.
	 * @param annotation
	 * @return
	 * @throws ClassNotFoundException
	 */
	public static Class<? extends UserInterceptor> get(Annotation annotation) throws ClassNotFoundException {
		return get(annotation.getClass().getSimpleName());
	}

	/**
	 * 인터셉터 맵에 인터셉터 클래스를 추가합니다.
	 * @param simpleName
	 * @throws ClassNotFoundException
	 */
	@SuppressWarnings("unchecked")
	private static void addInterceptor(String simpleName) throws ClassNotFoundException {
		String interceptorName = "web.interceptor." + simpleName + "Interceptor";
		Class<?> clazz = Class.forName(interceptorName);
		if (!UserInterceptor.class.isAssignableFrom(clazz)) {
			throw new ClassNotFoundException("Interceptor is must implemented Interceptor interface");
		}
		try {
			clazz.newInstance();
		} catch (InstantiationException e) {
			throw new ClassNotFoundException("Interceptor is must implemented default constructor.");
		} catch (IllegalAccessException e) {
			throw new ClassNotFoundException("Can not create new instance of Interceptor class.");
		}
		interceptorClasses.put(simpleName, (Class<? extends UserInterceptor>) clazz);
	}
}