package net.kldp.beat.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

import net.kldp.beat.exception.ConfigException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Beat framework의 환경 설정을 로드합니다.
 * 
 */
public class Config {
	private static final String SYSTEM_FILE = "/net/kldp/beat/configuration/beat.xml";
	private static final String USER_FILE = "/beat.xml";
	private static final String VERSION = "0.5";
	private static Log logger = LogFactory.getLog(Config.class);
	private static Class<?> cl;
	private static ConfigParser parser;

	public static String version() {
		return VERSION;
	}

	public static int bufferSize() {
		return parser.bufferSize;
	}

	public static boolean devMode() {
		return parser.devMode;
	}

	public static int maxSize() {
		return parser.maxSize;
	}

	public static String saveDir() {
		if (parser.saveDir.equals("")) {
			parser.saveDir = getDefaultTempDir();
		}
		return parser.saveDir;
	}

	public static ActionMapping defaultMapping() {
		return parser.defaultMapping;
	}

	public static ActionMapping getMapping(String namespace) {
		for (ActionMapping mapping : parser.mappings) {
			if (mapping.getMappingLocation().equals(namespace))
				return mapping;
		}
		return parser.defaultMapping;
	}

	public static String viewType() {
		return parser.viewType;
	}

	public static String viewSuffix() {
		if (parser.viewType.equals("jsp")) {
			return "jsp";
		} else if (parser.viewType.equals("velocity")) {
			return "vm";
		} else if (parser.viewType.equals("freemaker")) {
			return "fm";
		}
		return "jsp";
	}

	private static boolean loadConfiguration(String filename) throws ConfigException {
		URL url = cl.getResource(filename);
		if (url != null) {
			try {
//				parser = new ConfigParser(new File(url.getFile()));
				parser = new ConfigParser(url.getPath());
				System.out.println(parser);
				return true;
			} catch (Exception e) {
				logger.fatal(e);
				throw new ConfigException("can not parsing beat configuration file:" + filename);
			}
		}
		return false;
	}

	public static void load(Class<?> clazz) throws ConfigException {
		cl = clazz;
		if (!loadConfiguration(USER_FILE))
			if (!loadConfiguration(SYSTEM_FILE))
				throw new ConfigException("can not load beat configuration file");
		parser.parse();
	}

	/**
	 * 프로퍼티 파일을 로드합니다.
	 * 
	 * @param filename
	 * @return
	 * @throws IOException
	 */
	public static Properties loadProperties(String filename) throws IOException {
		Properties properties = new Properties();
		properties.load(cl.getResourceAsStream(filename));
		return properties;
	}

	/**
	 * 기본적으로 임시 파일이 저장될 디렉토리를 리턴합니다.
	 * 
	 * @return
	 */
	private static String getDefaultTempDir() {
		return System.getProperty("java.io.tmpdir");
	}
}