package net.kldp.beat.action;

import java.lang.reflect.Method;

import net.kldp.beat.annotation.After;
import net.kldp.beat.annotation.Before;
import net.kldp.beat.annotation.BeforeResult;
import net.kldp.beat.exception.ActionExecuteException;

public class ActionInvoker {
	private Object action;
	private Method beforeMethod;
	private Method resultBeforeMethod;
	private Method afterMethod;

	public ActionInvoker(Object action) {
		this.action = action;
		classifyMethods(action.getClass().getMethods());
	}

	/**
	 * Action클래스안에서의 특별한 메서드들을 분류합니다. 이들 메서드는 Before, BeforResult, After를 선언한
	 * 메서드입니다.
	 * 
	 * @param methods
	 */
	private void classifyMethods(Method[] methods) {
		for (Method method : methods) {
			Before before = method.getAnnotation(Before.class);
			After after = method.getAnnotation(After.class);
			BeforeResult resultBefore = method.getAnnotation(BeforeResult.class);
			if (before != null && beforeMethod == null) {
				this.beforeMethod = method;
			} else if (resultBefore != null && resultBeforeMethod == null) {
				this.resultBeforeMethod = method;
			} else if (after != null && afterMethod == null) {
				this.afterMethod = method;
			}
		}
	}

	public String execute() throws ActionExecuteException {
		try {
			Method method = action.getClass().getMethod("execute");
			return (String) method.invoke(action);
		} catch (Exception e) {
			throw new ActionExecuteException(e);
		}
	}

	public void executeBefore() throws ActionExecuteException {
		if (beforeMethod != null)
			invokeMethod(beforeMethod);
	}

	public void executeAfter() throws ActionExecuteException {
		if (afterMethod != null)
			invokeMethod(afterMethod);
	}

	public void executeBeforeResult() throws ActionExecuteException {
		if (resultBeforeMethod != null)
			invokeMethod(resultBeforeMethod);
	}

	private void invokeMethod(Method method) throws ActionExecuteException {
		try {
			method.invoke(action);
		} catch (Exception e) {
			throw new ActionExecuteException(e);
		}
	}
}