package net.kldp.beat.action;

import java.util.HashMap;
import java.util.Map;

import net.kldp.beat.exception.ActionMappingException;

public class ActionClassPool {
	private static Map<String, Class<? extends Object>> actionClasses = new HashMap<String, Class<? extends Object>>();
	private static boolean devMode = false;

	public static Class<? extends Object> get(String className) throws ClassNotFoundException,
			ActionMappingException {
		if (devMode)
			return findActionClass(className);
		if (!actionClasses.containsKey(className)) {
			addAction(className);
		}
		return actionClasses.get(className);
	}

	private static void addAction(String className) throws ClassNotFoundException, ActionMappingException {
		actionClasses.put(className, findActionClass(className));
	}

	private static Class<?> findActionClass(String className) throws ClassNotFoundException,
			ActionMappingException {
		String fullClassName = "web.controller" + className + "Action";
		Class<?> clazz = Class.forName(fullClassName);
		try {
			clazz.newInstance();
		} catch (InstantiationException e) {
			throw new ActionMappingException("can not found action class");
		} catch (IllegalAccessException e) {
			throw new ActionMappingException("Can not create new instance of Action class.");
		}
		return clazz;
	}

	public static synchronized void setDevMode(boolean mode) {
		devMode = mode;
	}
}