/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.web.annotation.ApplicationMap;
import net.kldp.beat.web.annotation.CookieMap;
import net.kldp.beat.web.annotation.HeaderMap;
import net.kldp.beat.web.annotation.Multipart;
import net.kldp.beat.web.annotation.Parameter;
import net.kldp.beat.web.annotation.ParameterMap;
import net.kldp.beat.web.annotation.RequestMap;
import net.kldp.beat.web.annotation.ServletContext;
import net.kldp.beat.web.annotation.ServletDispatcher;
import net.kldp.beat.web.annotation.ServletOutputStream;
import net.kldp.beat.web.annotation.ServletRequest;
import net.kldp.beat.web.annotation.ServletResponse;
import net.kldp.beat.web.annotation.SessionMap;
import net.kldp.beat.web.interceptor.ApplicationMapInterceptor;
import net.kldp.beat.web.interceptor.CookieMapInterceptor;
import net.kldp.beat.web.interceptor.HeaderMapInterceptor;
import net.kldp.beat.web.interceptor.MultipartInterceptor;
import net.kldp.beat.web.interceptor.ParameterInterceptor;
import net.kldp.beat.web.interceptor.ParameterMapInterceptor;
import net.kldp.beat.web.interceptor.RequestMapInterceptor;
import net.kldp.beat.web.interceptor.ServletContextInterceptor;
import net.kldp.beat.web.interceptor.ServletDispatcherInterceptor;
import net.kldp.beat.web.interceptor.ServletOutputStreamInterceptor;
import net.kldp.beat.web.interceptor.ServletRequestInterceptor;
import net.kldp.beat.web.interceptor.ServletResponseInterceptor;
import net.kldp.beat.web.interceptor.SessionMapInterceptor;

public final class SystemInterceptorPool {
    private static HashMap<Class<? extends Annotation>, SystemInterceptor> interceptors = new HashMap();

    private SystemInterceptorPool() {
    }

    public static SystemInterceptor getInterceptor(Annotation annotation) throws InterceptorException {
        Class<? extends Annotation> clazz = annotation.annotationType();
        if (interceptors.containsKey(clazz)) {
            return interceptors.get(clazz);
        }
        throw new InterceptorException("Can not found System Interceptor.");
    }

    static {
        interceptors.put(ApplicationMap.class, new ApplicationMapInterceptor());
        interceptors.put(Parameter.class, new ParameterInterceptor());
        interceptors.put(ParameterMap.class, new ParameterMapInterceptor());
        interceptors.put(Multipart.class, new MultipartInterceptor());
        interceptors.put(RequestMap.class, new RequestMapInterceptor());
        interceptors.put(ServletContext.class, new ServletContextInterceptor());
        interceptors.put(ServletDispatcher.class, new ServletDispatcherInterceptor());
        interceptors.put(ServletRequest.class, new ServletRequestInterceptor());
        interceptors.put(ServletResponse.class, new ServletResponseInterceptor());
        interceptors.put(ServletOutputStream.class, new ServletOutputStreamInterceptor());
        interceptors.put(HeaderMap.class, new HeaderMapInterceptor());
        interceptors.put(CookieMap.class, new CookieMapInterceptor());
        interceptors.put(SessionMap.class, new SessionMapInterceptor());
    }
}

