/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.Interceptor;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.annotation.ApplicationMap;
import net.kldp.beat.web.annotation.CookieMap;
import net.kldp.beat.web.annotation.HeaderMap;
import net.kldp.beat.web.annotation.Multipart;
import net.kldp.beat.web.annotation.Parameter;
import net.kldp.beat.web.annotation.ParameterMap;
import net.kldp.beat.web.annotation.RequestMap;
import net.kldp.beat.web.annotation.ServletContext;
import net.kldp.beat.web.annotation.ServletDispatcher;
import net.kldp.beat.web.annotation.ServletOutputStream;
import net.kldp.beat.web.annotation.ServletRequest;
import net.kldp.beat.web.annotation.ServletResponse;
import net.kldp.beat.web.annotation.SessionMap;
import net.kldp.beat.web.interceptor.ApplicationMapInterceptor;
import net.kldp.beat.web.interceptor.CookieMapInterceptor;
import net.kldp.beat.web.interceptor.HeaderMapInterceptor;
import net.kldp.beat.web.interceptor.MultipartInterceptor;
import net.kldp.beat.web.interceptor.ParameterInterceptor;
import net.kldp.beat.web.interceptor.ParameterMapInterceptor;
import net.kldp.beat.web.interceptor.RequestMapInterceptor;
import net.kldp.beat.web.interceptor.ServletContextInterceptor;
import net.kldp.beat.web.interceptor.ServletDispatcherInterceptor;
import net.kldp.beat.web.interceptor.ServletOutputStreamInterceptor;
import net.kldp.beat.web.interceptor.ServletRequestInterceptor;
import net.kldp.beat.web.interceptor.ServletResponseInterceptor;
import net.kldp.beat.web.interceptor.SessionMapInterceptor;

public abstract class InterceptorFactory
implements SystemInterceptor {
    private static HashMap<Class<? extends Annotation>, SystemInterceptor> interceptors = new HashMap();

    public static Interceptor getInterceptor(Annotation annotation) throws InterceptorException {
        Class<? extends Annotation> clazz = annotation.annotationType();
        if (interceptors.containsKey(clazz)) {
            return interceptors.get(clazz);
        }
        return InterceptorFactory.createUserInterceptor(clazz);
    }

    public static Interceptor getInterceptor(Class clazz) throws InterceptorException {
        if (interceptors.containsKey(clazz)) {
            return interceptors.get(clazz);
        }
        return InterceptorFactory.createUserInterceptor(clazz);
    }

    private static Interceptor createUserInterceptor(Class<? extends Annotation> clazz) throws InterceptorException {
        String string = "web.interceptor." + clazz.getSimpleName() + "Interceptor";
        try {
            return (Interceptor)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new InterceptorException(exception);
        }
    }

    public static void intecept(UserInterceptor userInterceptor, ActionContext actionContext, Annotation annotation) throws InterceptorException {
        SystemInterceptor systemInterceptor = interceptors.get(annotation.annotationType());
        if (systemInterceptor != null) {
            systemInterceptor.intercept(userInterceptor, actionContext, annotation);
        }
    }

    public static void intecept(Object object, Map<SystemInterceptor, Annotation> map, ActionContext actionContext) throws InterceptorException {
        ArrayList<SystemInterceptor> arrayList = new ArrayList<SystemInterceptor>();
        SystemInterceptor systemInterceptor = null;
        for (SystemInterceptor systemInterceptor2 : map.keySet()) {
            if (systemInterceptor2 instanceof MultipartInterceptor) {
                systemInterceptor = systemInterceptor2;
                continue;
            }
            arrayList.add(systemInterceptor2);
        }
        if (systemInterceptor != null) {
            System.out.println("MULTIPART");
            systemInterceptor.intercept(object, actionContext, map.get(systemInterceptor));
        }
        interceptors.get(Parameter.class).intercept(object, actionContext, new Parameter(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Parameter.class;
            }
        });
        for (SystemInterceptor systemInterceptor2 : arrayList) {
            systemInterceptor2.intercept(object, actionContext, map.get(systemInterceptor2));
        }
    }

    static {
        interceptors.put(ApplicationMap.class, new ApplicationMapInterceptor());
        interceptors.put(Parameter.class, new ParameterInterceptor());
        interceptors.put(ParameterMap.class, new ParameterMapInterceptor());
        interceptors.put(Multipart.class, new MultipartInterceptor());
        interceptors.put(RequestMap.class, new RequestMapInterceptor());
        interceptors.put(ServletContext.class, new ServletContextInterceptor());
        interceptors.put(ServletDispatcher.class, new ServletDispatcherInterceptor());
        interceptors.put(ServletRequest.class, new ServletRequestInterceptor());
        interceptors.put(ServletResponse.class, new ServletResponseInterceptor());
        interceptors.put(ServletOutputStream.class, new ServletOutputStreamInterceptor());
        interceptors.put(HeaderMap.class, new HeaderMapInterceptor());
        interceptors.put(CookieMap.class, new CookieMapInterceptor());
        interceptors.put(SessionMap.class, new SessionMapInterceptor());
    }
}

