/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kldp.beat.action.AnnotationFinder;
import net.kldp.beat.annotation.After;
import net.kldp.beat.annotation.Before;
import net.kldp.beat.annotation.BeforeResult;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.annotation.Results;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.exception.ResultException;
import net.kldp.beat.interceptor.AfterInterceptor;
import net.kldp.beat.interceptor.BeforeInterceptor;
import net.kldp.beat.interceptor.Interceptor;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterceptorStack {
    private Log logger = LogFactory.getLog(InterceptorStack.class);
    private List<Result> results = new ArrayList<Result>();
    private Map<UserInterceptor, Annotation> beforeInterceptors = new HashMap<UserInterceptor, Annotation>();
    private Map<UserInterceptor, Annotation> afterInterceptors = new HashMap<UserInterceptor, Annotation>();
    private Map<SystemInterceptor, Annotation> systemInterceptors = new HashMap<SystemInterceptor, Annotation>();
    private Method beforeMethod;
    private Method afterMethod;
    private Method resultBeforeMethod;

    public InterceptorStack(Class<? extends Object> clazz) throws ResultException {
        AnnotationFinder annotationFinder = new AnnotationFinder(clazz);
        annotationFinder.find();
        for (Annotation annotation : annotationFinder.getAnnotations()) {
            System.out.println(annotation);
            this.classifyAnnotations(annotation);
        }
        this.classifyMethods(clazz.getMethods());
    }

    private void classifyMethods(Method[] methodArray) {
        for (Method method : methodArray) {
            Before before = method.getAnnotation(Before.class);
            After after = method.getAnnotation(After.class);
            BeforeResult beforeResult = method.getAnnotation(BeforeResult.class);
            if (before != null && this.beforeMethod == null) {
                this.beforeMethod = method;
                continue;
            }
            if (beforeResult != null && this.resultBeforeMethod == null) {
                this.resultBeforeMethod = method;
                continue;
            }
            if (after == null || this.afterMethod != null) continue;
            this.afterMethod = method;
        }
    }

    private void classifyAnnotations(Annotation annotation) throws ResultException {
        if (annotation instanceof Result) {
            this.addResult((Result)annotation);
        } else if (annotation instanceof Results) {
            Results results = (Results)annotation;
            for (Result result : results.value()) {
                this.addResult(result);
            }
        } else {
            this.classifyInterceptors(annotation);
        }
    }

    private void addResult(Result result) throws ResultException {
        if (!result.value().equals("") && result.value().charAt(0) != '/') {
            throw new ResultException("value is must start at '/' in Result annotation");
        }
        this.results.add(result);
    }

    private void classifyInterceptors(Annotation annotation) {
        try {
            Interceptor interceptor = InterceptorFactory.getInterceptor(annotation);
            if (interceptor instanceof SystemInterceptor) {
                this.systemInterceptors.put((SystemInterceptor)interceptor, annotation);
            } else {
                if (interceptor instanceof BeforeInterceptor) {
                    this.beforeInterceptors.put((UserInterceptor)interceptor, annotation);
                }
                if (interceptor instanceof AfterInterceptor) {
                    this.afterInterceptors.put((UserInterceptor)interceptor, annotation);
                }
            }
        }
        catch (InterceptorException interceptorException) {
            this.logger.error((Object)interceptorException);
        }
    }

    public List<Result> getResults() {
        return this.results;
    }

    public boolean hasResults() {
        return this.results.size() > 0;
    }

    public Result getResult(String string) throws ResultException {
        for (Result result : this.results) {
            if (!result.name().equals(string)) continue;
            return result;
        }
        throw new ResultException("can not found Result for name=" + string);
    }

    public Map<SystemInterceptor, Annotation> getSystemInterceptors() {
        return this.systemInterceptors;
    }

    public Map<UserInterceptor, Annotation> getBeforeInterceptors() {
        return this.beforeInterceptors;
    }

    public Map<UserInterceptor, Annotation> getAfterInterceptors() {
        return this.afterInterceptors;
    }

    public Method getBeforeMethod() {
        return this.beforeMethod;
    }

    public Method getAfterMethod() {
        return this.afterMethod;
    }

    public Method getBeforeResultMethod() {
        return this.resultBeforeMethod;
    }
}

