package net.kldp.beat.dispatcher;

import java.io.IOException;

import javax.servlet.ServletException;

import net.kldp.beat.action.PropertyCopy;
import net.kldp.beat.annotation.Result;

class JspViewDispatcher extends ViewDispatcher {

	@Override
	public void dispatch(Result input, Object action) throws ServletException, IOException {
		String type = input.type().toLowerCase();
		if (type.equals(FORWARD)) {
			String url = getViewPath() + input.value();
			System.out.println(url);
			url = interpretString(url, PropertyCopy.beanToMap(action));
			if (input.params() != null && input.params().length > 0) {
				String param = interpretString(arrayToParam(input.params()), PropertyCopy.beanToMap(action));
				url += "?" + param;
			}
			dispatch(url, type);
		} else if (type.equals(REDIRECT)) {
			dispatch(input.value(), type);
		} else if (type.equals(STREAM)) {
			String url = interpretString(input.value(), PropertyCopy.beanToMap(action));
			response.setContentType(input.contentType());
			String headers[] = parseHeaders(input.headers(), PropertyCopy.beanToMap(action));
			addHeaders(headers, response);
			System.out.println(input.contentType());
			dispatch(url, type);
		} else {
			throw new ServletException("can not dispath Result. unknown type - " + type);
		}
	}
}