/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kldp.beat.annotation.Beat;

public class AnnotationFinder {
    private Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private Class<?> actionClass;

    public AnnotationFinder(Class<?> clazz) {
        this.actionClass = clazz;
    }

    public void find() {
        this.findAll();
    }

    private void findAll() {
        this.annotations = this.findAnnotation(this.actionClass);
        for (Class<?> clazz : this.actionClass.getInterfaces()) {
            this.putAnnotation(this.findAnnotation(clazz));
        }
        Object object = this.actionClass.getSuperclass();
        while (!object.equals(Object.class)) {
            for (Class<?> clazz : ((Class)object).getInterfaces()) {
                this.putAnnotation(this.findAnnotation(clazz));
            }
            object = ((Class)object).getSuperclass();
        }
    }

    private void putAnnotation(Map<Class<? extends Annotation>, Annotation> map) {
        for (Class<? extends Annotation> clazz : map.keySet()) {
            if (this.annotations.containsKey(clazz)) continue;
            this.annotations.put(clazz, map.get(clazz));
        }
    }

    private Map<Class<? extends Annotation>, Annotation> findAnnotation(Class<?> clazz) {
        HashMap<Class<? extends Annotation>, Annotation> hashMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!AnnotationFinder.isBeat(annotation)) continue;
            hashMap.put(annotation.getClass(), annotation);
        }
        return hashMap;
    }

    public List<Annotation> getAnnotations() {
        return new ArrayList<Annotation>(this.annotations.values());
    }

    public static boolean isBeat(Annotation annotation) {
        for (Annotation annotation2 : annotation.annotationType().getAnnotations()) {
            if (!(annotation2 instanceof Beat)) continue;
            return true;
        }
        return false;
    }
}

