package net.kldp.beat.map;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractMap implements Map<String, Object> {
	Map<String, Object> map = new HashMap<String, Object>();

	abstract Enumeration<String> getAttributeNames();

	abstract void removeAttribute(String key);

	abstract Object getAttribute(String key);

	abstract void setAttribute(String key, Object value);

	public void clear() {
		for (Enumeration<String> e = getAttributeNames(); e.hasMoreElements();) {
			removeAttribute(e.nextElement());
		}
	}

	public boolean containsKey(Object key) {
		if (getAttribute((String) key) != null)
			return true;
		return false;
	}

	public boolean containsValue(Object value) {
		for (Enumeration<String> e = getAttributeNames(); e.hasMoreElements();) {
			if (value.equals(getAttribute(e.nextElement())))
				return true;
		}
		return false;
	}

	public Set<java.util.Map.Entry<String, Object>> entrySet() {
		map.clear();
		for (Enumeration<String> e = getAttributeNames(); e.hasMoreElements();) {
			String key = e.nextElement();
			Object value = getAttribute(key);
			map.put(key, value);
		}
		return map.entrySet();
	}

	public Object get(Object key) {
		return getAttribute((String) key);
	}

	public boolean isEmpty() {
		Enumeration<String> attributeNames = getAttributeNames();
		if (attributeNames.hasMoreElements())
			return true;
		return false;
	}

	public Set<String> keySet() {
		Set<String> set = new HashSet<String>();
		for (Enumeration<String> e = getAttributeNames(); e.hasMoreElements();) {
			set.add(e.nextElement());
		}
		return set;
	}

	public Object put(String key, Object value) {
		setAttribute(key, value);
		return value;
	}

	public void putAll(Map<? extends String, ? extends Object> m) {
		Set<? extends String> keySet = m.keySet();
		for (String key : keySet) {
			setAttribute(key, m.get(key));
		}
	}

	public Object remove(Object key) {
		Object obj = getAttribute((String) key);
		removeAttribute((String) key);
		return obj;
	}

	public int size() {
		int count = 0;
		for (Enumeration<String> e = getAttributeNames(); e.hasMoreElements();) {
			count++;
		}
		return count;
	}

	public Collection<Object> values() {
		Set<Object> set = new HashSet<Object>();
		for (Enumeration<String> e = getAttributeNames(); e.hasMoreElements();) {
			Object attribute = getAttribute(e.nextElement());
			set.add(attribute);
		}
		return set;
	}

}