package net.kldp.beat.action;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.config.Config;

import org.apache.commons.beanutils.PropertyUtils;

public class ServletDispatcherImpl implements ServletDispatcher {

	private HttpServletRequest request;
	private HttpServletResponse response;
	private ServletContext context;
	private static final String REDIRECT = "redirect";
	private static final String FORWARD = "forward";
	private static final String STREAM = "stream";

	public ServletDispatcherImpl(ServletContext context, HttpServletRequest request,
			HttpServletResponse response) {
		this.context = context;
		this.request = request;
		this.response = response;
	}

	@Override
	public String getRequestURI() {
		return request.getRequestURI();
	}

	@Override
	public String getQueryString() {
		return request.getQueryString();
	}

	@Override
	public void dispatch(String url, String type) throws ServletException, IOException {
		if (type.equals(REDIRECT)) {
			response.sendRedirect(url);
		} else if (type.equals(FORWARD)) {
			RequestDispatcher dispatcher = context.getRequestDispatcher(url);
			dispatcher.forward(request, response);
		} else if (type.equals(STREAM)) {
			FileInputStream in = new FileInputStream(url);
			ServletOutputStream os = response.getOutputStream();
			byte[] buf = new byte[1024];
			int read = 0;
			while ((read = in.read(buf)) != -1) {
				os.write(buf, 0, read);
			}
			in.close();
			os.close();
		} else {
			throw new ServletException("can not dispath Result. unknown type - " + type);
		}
	}

	@Override
	public void dispatch(Result input, Object action) throws ServletException, IOException {
		String type = input.type().toLowerCase();
		if (type.equals(FORWARD)) {
			String url = Config.view_path() + input.value();
			System.out.println(url);
			url = interpretString(url, actionToMap(action));
			if (input.params() != null && input.params().length > 0) {
				String param = interpretString(arrayToParam(input.params()), actionToMap(action));
				url += "?" + param;
			}
			dispatch(url, type);
		} else if (type.equals(REDIRECT)) {
			dispatch(input.value(), type);
		} else if (type.equals(STREAM)) {
			String url = interpretString(input.value(), actionToMap(action));
			response.setContentType(input.contentType());
			dispatch(url, type);
		} else {
			throw new ServletException("can not dispath Result. unknown type - " + type);
		}
	}

	private String interpretString(String result, Map<String, Object> map) {
		for (String key : map.keySet()) {
			System.out.println(key);
			Object value = map.get(key);
			System.out.println(value);
			if(value != null)
				result = result.replaceAll("\\$\\{" + key + "}", value.toString());
		}
		return result;
	}

	@SuppressWarnings("unchecked")
	private Map<String, Object> actionToMap(Object action) {
		try {
			Map<String, Object> map = null;
			map = PropertyUtils.describe(action);
			map.remove("class");
			return map;
		} catch (Exception e) {
		}
		return new HashMap<String, Object>();
	}

	private String arrayToParam(String[] params) {
		StringBuffer buffer = new StringBuffer();
		for (String param : params)
			buffer.append(param + "&");
		if (buffer.length() < 1)
			return "";
		return buffer.substring(0, buffer.length() - 1);
	}
}