package net.kldp.beat.action;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.map.ApplicationMap;
import net.kldp.beat.map.ParameterMap;
import net.kldp.beat.map.RequestMap;
import net.kldp.beat.map.SessionMap;

public class ActionContext {

	private Map<String, Object> parameterMap;
	private Map<String, Object> requestMap;
	private Map<String, Object> sessionMap;
	private Map<String, Object> applicationMap;
	private HttpServletRequest request;
	private HttpServletResponse response;
	private ServletContext context;
	private Map<String, String> errorsMap;

	public ActionContext(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
		this.request = request;
		this.response = response;
		this.context = context;
	}

	public Map<String, Object> getRequestMap() {
		if (requestMap == null) {
			requestMap = new RequestMap(request);
		}
		return requestMap;
	}

	public Map<String, Object> getApplicationMap() {
		if (applicationMap == null) {
			applicationMap = new ApplicationMap(context);
		}
		return applicationMap;
	}

	public Map<String, Object> getSessionMap() {
		if (sessionMap == null) {
			sessionMap = new SessionMap(request.getSession());
		}
		return sessionMap;
	}

	public Map<String, Object> getParameterMap() {
		System.out.println("getParameterMap");
		if (parameterMap == null) {
			parameterMap = new ParameterMap(request);
		}
		return parameterMap;
	}

	public ServletContext getServletContext() {
		return context;
	}

	public HttpServletRequest getServletRequest() {
		return request;
	}

	public HttpServletResponse getServletResponse() {
		return response;
	}

	public ServletDispatcher getServletDispatcher() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setErrorsMap(Map<String, String> errorsMap) {
		this.errorsMap = errorsMap;
	}

	public Map<String, String> getErrorsMap() {
		if (errorsMap == null)
			errorsMap = new HashMap<String, String>();
		return errorsMap;
	}

	public void setParameterMap(Map<String, Object> parameterMap) {
		System.out.println("setParameterMap");
		this.parameterMap = parameterMap;
	}
}