package net.kldp.beat.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpSession;

public class SessionMap implements Map<String, Object> {

	private HttpSession session;

	public SessionMap(HttpSession session) {
		this.session = session;
	}

	@Override
	public void clear() {
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			session.removeAttribute(key);
		}
	}

	@Override
	public boolean containsKey(Object key) {
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			if (attributeNames.nextElement().equals(key))
				return true;
		}
		return false;
	}

	@Override
	public boolean containsValue(Object value) {
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			if (session.getAttribute(key).equals(key))
				return true;
		}
		return false;
	}

	@Override
	public Set<java.util.Map.Entry<String, Object>> entrySet() {
		Map<String, Object> map = new HashMap<String, Object>();
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			Object value = session.getAttribute(key);
			map.put(key, value);
		}
		return map.entrySet();
	}

	@Override
	public Object get(Object key) {
		return session.getAttribute((String) key);
	}

	@Override
	public boolean isEmpty() {
		Enumeration<String> attributeNames = session.getAttributeNames();
		if (attributeNames.hasMoreElements())
			return false;
		return true;
	}

	@Override
	public Set<String> keySet() {
		Set<String> set = new HashSet<String>();
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			set.add(key);
		}
		return set;
	}

	@Override
	public Object put(String key, Object value) {
		session.setAttribute(key, value);
		return value;
	}

	@Override
	public void putAll(Map<? extends String, ? extends Object> m) {
		Set<? extends String> keySet = m.keySet();
		for (String key : keySet) {
			session.setAttribute(key, m.get(key));
		}
	}

	@Override
	public Object remove(Object key) {
		Object value = session.getAttribute((String) key);
		session.removeAttribute((String) key);
		return value;
	}

	@Override
	public int size() {
		int count = 0;
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			attributeNames.nextElement();
			count++;
		}
		return count;
	}

	@Override
	public Collection<Object> values() {
		List<Object> list = new ArrayList<Object>();
		Enumeration<String> attributeNames = session.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			list.add(session.getAttribute(key));
		}
		return list;
	}
}