package net.kldp.beat.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

public class RequestMap implements Map<String, Object> {

	private HttpServletRequest request;

	public RequestMap(HttpServletRequest request) {
		this.request = request;
	}

	@Override
	public void clear() {
		Enumeration names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String attribute = (String) names.nextElement();
			request.removeAttribute(attribute);
		}
	}

	@Override
	public boolean containsKey(Object key) {
		if (request.getAttribute((String) key) != null)
			return true;
		return false;
	}

	@Override
	public boolean containsValue(Object value) {
		Enumeration names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String attribute = (String) names.nextElement();
			return request.getAttribute(attribute).equals(value);
		}
		return false;
	}

	@Override
	public Set<java.util.Map.Entry<String, Object>> entrySet() {
		Map<String, Object> map = new HashMap<String, Object>();
		Enumeration<String> attributeNames = request.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			Object value = request.getAttribute(key);
			map.put(key, value);
		}
		return map.entrySet();
	}

	@Override
	public Object get(Object key) {
		return request.getAttribute((String) key);
	}

	@Override
	public boolean isEmpty() {
		Enumeration names = request.getAttributeNames();
		if (names.hasMoreElements())
			return false;
		return true;
	}

	@Override
	public Set<String> keySet() {
		Set set = new HashSet<String>();
		Enumeration names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			set.add((String) names.nextElement());
		}
		return set;
	}

	@Override
	public Object put(String key, Object value) {
		request.setAttribute(key, value);
		return value;
	}

	@Override
	public void putAll(Map<? extends String, ? extends Object> m) {
		Set<? extends String> set = m.keySet();
		for (String key : set) {
			request.setAttribute(key, m.get(key));
		}
	}

	@Override
	public Object remove(Object key) {
		Object value = request.getAttribute((String) key);
		request.removeAttribute((String) key);
		return value;
	}

	@Override
	public int size() {
		Enumeration names = request.getAttributeNames();
		int count = 0;
		while (names.hasMoreElements()) {
			names.nextElement();
			count++;
		}
		return count;
	}

	@Override
	public Collection<Object> values() {
		List<Object> list = new ArrayList<Object>();
		Enumeration names = request.getAttributeNames();
		while (names.hasMoreElements()) {
			String attribute = (String) names.nextElement();
			list.add(request.getAttribute(attribute));
		}
		return list;
	}
}