package net.kldp.beat.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.config.Config;

import org.apache.commons.beanutils.PropertyUtils;

public class ServletDispatcherImpl implements ServletDispatcher {

	private HttpServletRequest request;
	private HttpServletResponse response;
	private ServletContext context;

	public ServletDispatcherImpl(ServletContext context, HttpServletRequest request,
			HttpServletResponse response) {
		this.context = context;
		this.request = request;
		this.response = response;
	}

	@Override
	public String getRequestURI() {
		return request.getRequestURI();
	}

	@Override
	public String getQueryString() {
		return request.getQueryString();
	}

	@Override
	public void dispatch(String url, String type) throws ServletException, IOException {
		if (type.equals("include")) {
			RequestDispatcher dispatcher = context.getRequestDispatcher(url);
			dispatcher.include(request, response);
		} else if (type.equals("redirect")) {
			response.sendRedirect(url);
		} else { // type.equals("forward")
			RequestDispatcher dispatcher = context.getRequestDispatcher(url);
			dispatcher.forward(request, response);
		}
	}

	@Override
	public void dispatch(Result input, Object action) throws ServletException, IOException {
		String type = input.type();
		if (type.equals("redirect"))
			dispatch(input.value(), type);
		String url = Config.view_path() + input.value();
		if (input.params() != null && input.params().length > 0) {

			String param = arrayToParam(input.params());
			try {
				Map<String, Object> temp;
				temp = PropertyUtils.describe(action);
				temp.remove("class");
				for (String key : temp.keySet()) {
					param = param.replaceAll("\\$\\{" + key + "}", temp.get(key).toString());
				}
			} catch (IllegalAccessException e) {
			} catch (InvocationTargetException e) {
			} catch (NoSuchMethodException e) {
			}
			url += "?" + param;
		}
		dispatch(url, type);
	}

	private String arrayToParam(String[] params) {
		StringBuffer buffer = new StringBuffer();
		for (String param : params)
			buffer.append(param + "&");
		if (buffer.length() < 1)
			return "";
		return buffer.substring(0, buffer.length() - 1);
	}
}