package net.kldp.beat.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;

import net.kldp.beat.annotation.After;
import net.kldp.beat.annotation.Beat;
import net.kldp.beat.annotation.Before;
import net.kldp.beat.annotation.Multipart;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.annotation.BeforeResult;
import net.kldp.beat.annotation.Results;
import net.kldp.beat.interceptor.AroundInterceptor;
import net.kldp.beat.interceptor.BeforeInterceptor;
import net.kldp.beat.interceptor.Interceptor;

public class InterceptorStack {

	private boolean isMultipart = false;
	private Multipart multipart;
	private List<Result> results = new ArrayList<Result>();
	private Map<Interceptor, Annotation> before = new HashMap<Interceptor, Annotation>();
	private Map<Interceptor, Annotation> after = new HashMap<Interceptor, Annotation>();
	private Method beforeMethod;
	private Method afterMethod;
	private Method resultBeforeMethod;

	public InterceptorStack(Object action, AwareInjector injector) throws ServletException {

		Annotation[] annotations = action.getClass().getAnnotations();
		for (Annotation annotation : annotations) {

			if (!isBeat(annotation))
				continue;

			if (annotation instanceof Multipart) {
				isMultipart = true;
				multipart = (Multipart) annotation;
			} else if (annotation instanceof Result) {
				results.add((Result) annotation);
			} else if (annotation instanceof Results) {
				Results _results = (Results) annotation;
				for (Result result : _results.value()) {
					results.add(result);
				}
			} else {
				String name = annotation.annotationType().getSimpleName();
				String interceptorName = "web.interceptor." + name + "Interceptor";
				try {
					Interceptor interceptor = (Interceptor) Class.forName(interceptorName).newInstance();
					injector.injection(interceptor);
					if (interceptor instanceof AroundInterceptor) {
						before.put(interceptor, annotation);
						after.put(interceptor, annotation);
					} else if (interceptor instanceof BeforeInterceptor) {
						before.put(interceptor, annotation);
					} else {
						after.put(interceptor, annotation);
					}
				} catch (Exception e) {
					throw new ServletException("Can not found Interceptor class :" + interceptorName);
				}
			}
		}
		Method[] methods = action.getClass().getMethods();
		for (Method method : methods) {
			Before before = method.getAnnotation(Before.class);
			After after = method.getAnnotation(After.class);
			BeforeResult resultBefore = method.getAnnotation(BeforeResult.class);
			if (before != null && beforeMethod == null) {
				this.beforeMethod = method;
			} else if (resultBefore != null && resultBeforeMethod == null) {
				this.resultBeforeMethod = method;
			} else if (after != null && afterMethod == null) {
				this.afterMethod = method;
			}
		}
	}

	private boolean isBeat(Annotation annotation) {
		for (Annotation anno : annotation.annotationType().getAnnotations()) {
			if (anno instanceof Beat)
				return true;
		}
		return false;
	}

	public boolean isMultipart() {
		return isMultipart;
	}

	public Multipart getMultipart() {
		return multipart;
	}

	public List<Result> getResults() {
		return results;
	}

	public Result getResult(String resultString) {
		for (Result result : results) {
			if (result.name().equals(resultString))
				return result;
		}
		return null;
	}

	public Map<Interceptor, Annotation> getBeforeInterceptors() {
		return before;
	}

	public Map<Interceptor, Annotation> getAfterInterceptors() {
		return after;
	}

	public Method getBeforeMethod() {
		return beforeMethod;
	}

	public Method getAfterMethod() {
		return afterMethod;
	}

	public Method getBeforeResultMethod() {
		return resultBeforeMethod;
	}
}