package net.kldp.beat.action;

import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.aware.ApplicationAware;
import net.kldp.beat.aware.ParameterAware;
import net.kldp.beat.aware.RequestAware;
import net.kldp.beat.aware.ServletContextAware;
import net.kldp.beat.aware.ServletDispatcherAware;
import net.kldp.beat.aware.ServletRequestAware;
import net.kldp.beat.aware.ServletResponseAware;
import net.kldp.beat.aware.SessionAware;
import net.kldp.beat.aware.ValidationAware;
import net.kldp.beat.exception.ValidationException;
import net.kldp.beat.map.ApplicationMap;
import net.kldp.beat.map.RequestMap;
import net.kldp.beat.map.SessionMap;

public class AwareInjector {

	private HttpServletResponse response;
	private HttpServletRequest request;
	private Map<String, String> parameterMap;
	private Map<String, Object> sessionMap;
	private Map<String, Object> requestMap;
	private Map<String, Object> applicationMap;
	private ServletContext context;

	public AwareInjector(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
		this.context = context;
		this.request = request;
		this.response = response;
	}

	public boolean injection(Object target) {
		applicationAware(target);
		parameterAware(target);
		sessionAware(target);
		requestAware(target);
		servletContextAware(target);
		servletRequestAware(target);
		servletResponseAware(target);
		servletDispatcherAware(target);
		return true;
	}

	public Map<String, String> getParameterMap() {
		if (parameterMap == null) {
			parameterMap = request.getParameterMap();
		}
		return parameterMap;
	}

	public Map<String, Object> getSessionMap() {
		if (sessionMap == null)
			sessionMap = new SessionMap(request.getSession());
		return sessionMap;
	}

	public Map<String, Object> getRequestMap() {
		if (requestMap == null)
			requestMap = new RequestMap(request);
		return requestMap;
	}

	public Map<String, Object> getApplicationMap() {
		if (applicationMap == null) {
			applicationMap = new ApplicationMap(context);
		}
		return applicationMap;
	}

	private void requestAware(Object target) {
		if (target instanceof RequestAware) {
			RequestAware aware = (RequestAware) target;
			aware.setRequest(getRequestMap());
		}
	}

	private void sessionAware(Object target) {
		if (target instanceof SessionAware) {
			SessionAware aware = (SessionAware) target;
			aware.setSession(getSessionMap());
		}
	}

	private void servletDispatcherAware(Object target) {
		if (target instanceof ServletDispatcherAware) {
			ServletDispatcherAware aware = (ServletDispatcherAware) target;
			ServletDispatcher dispatcher = new ServletDispatcherImpl(context, request, response);
			aware.setServletDispatcher(dispatcher);
		}
	}

	private void servletResponseAware(Object target) {
		if (target instanceof ServletResponseAware) {
			ServletResponseAware aware = (ServletResponseAware) target;
			aware.setServletResponse(response);
		}
	}

	private void servletRequestAware(Object target) {
		if (target instanceof ServletRequestAware) {
			ServletRequestAware aware = (ServletRequestAware) target;
			aware.setServletRequest(request);
		}

	}

	private void servletContextAware(Object target) {
		if (target instanceof ServletContextAware) {
			ServletContextAware aware = (ServletContextAware) target;
			aware.setServletContext(context);
		}
	}

	private void parameterAware(Object target) {
		if (target instanceof ParameterAware) {
			ParameterAware aware = (ParameterAware) target;
			aware.setParameter(getParameterMap());
		}

	}

	private void applicationAware(Object target) {
		if (target instanceof ApplicationAware) {
			ApplicationAware aware = (ApplicationAware) target;
			aware.setApplication(getApplicationMap());
		}
	}

	public boolean validation(Object action) throws ValidationException {
		if (action instanceof ValidationAware) {
			ValidationAware aware = (ValidationAware) action;
			aware.validate();
			if (aware.getErrorsMap() == null)
				throw new ValidationException("Validation Exception. Errors Map is null");
			else if (aware.getErrorsMap().size() > 0)
				return false;
		}
		return true;
	}
}