package net.kldp.beat.action;

import java.lang.annotation.Annotation;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.config.Config;
import net.kldp.beat.exception.ActionMappingException;
import net.kldp.beat.exception.ServletPathParseException;

public class ActionMapper {

	private ServletPathParser parser;

	public ActionMapper(String servletPath) {
		this.parser = new ServletPathParser(servletPath, "action");
	}

	public Object createAction() throws ActionMappingException {
		Object action;
		try {
			String target = parser.getTargetClassName();
			action = Class.forName("web.controller" + target + "Action").newInstance();
		} catch (ServletPathParseException e) {
			throw new ActionMappingException("can not found action class");
		} catch (InstantiationException e) {
			throw new ActionMappingException("can not found action class");
		} catch (IllegalAccessException e) {
			throw new ActionMappingException("can not found action class");
		} catch (ClassNotFoundException e) {
			throw new ActionMappingException("can not found action class");
		}
		return action;
	}

	public String getDefaultView() {
		return Config.view_path() + parser.getDefaultView("jsp");
	}

	public Result getDefaultResult() {
		return new Result() {
			public String name() {
				return "success";
			}

			public String[] params() {
				return null;
			}

			public String type() {
				return "forward";
			}

			public String value() {
				return parser.getDefaultView("jsp");
			}

			public Class<? extends Annotation> annotationType() {
				return Result.class;
			}
		};
	}
}