/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.action.ServletDispatcherImpl;
import net.kldp.beat.aware.ApplicationAware;
import net.kldp.beat.aware.ParameterAware;
import net.kldp.beat.aware.RequestAware;
import net.kldp.beat.aware.ServletContextAware;
import net.kldp.beat.aware.ServletDispatcherAware;
import net.kldp.beat.aware.ServletRequestAware;
import net.kldp.beat.aware.ServletResponseAware;
import net.kldp.beat.aware.SessionAware;
import net.kldp.beat.aware.ValidationAware;
import net.kldp.beat.exception.ValidationException;
import net.kldp.beat.map.ApplicationMap;
import net.kldp.beat.map.RequestMap;
import net.kldp.beat.map.SessionMap;

public class AwareInjector {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private Map<String, String> parameterMap;
    private Map<String, Object> sessionMap;
    private Map<String, Object> requestMap;
    private Map<String, Object> applicationMap;
    private ServletContext context;

    public AwareInjector(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.context = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    public boolean injection(Object object) {
        this.applicationAware(object);
        this.parameterAware(object);
        this.sessionAware(object);
        this.requestAware(object);
        this.servletContextAware(object);
        this.servletRequestAware(object);
        this.servletResponseAware(object);
        this.servletDispatcherAware(object);
        return true;
    }

    public Map<String, String> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = this.request.getParameterMap();
        }
        return this.parameterMap;
    }

    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap(this.request.getSession());
        }
        return this.sessionMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.context);
        }
        return this.applicationMap;
    }

    private void requestAware(Object object) {
        if (object instanceof RequestAware) {
            RequestAware requestAware = (RequestAware)object;
            requestAware.setRequest(this.getRequestMap());
        }
    }

    private void sessionAware(Object object) {
        if (object instanceof SessionAware) {
            SessionAware sessionAware = (SessionAware)object;
            sessionAware.setSession(this.getSessionMap());
        }
    }

    private void servletDispatcherAware(Object object) {
        if (object instanceof ServletDispatcherAware) {
            ServletDispatcherAware servletDispatcherAware = (ServletDispatcherAware)object;
            ServletDispatcherImpl servletDispatcherImpl = new ServletDispatcherImpl(this.context, this.request, this.response);
            servletDispatcherAware.setServletDispatcher(servletDispatcherImpl);
        }
    }

    private void servletResponseAware(Object object) {
        if (object instanceof ServletResponseAware) {
            ServletResponseAware servletResponseAware = (ServletResponseAware)object;
            servletResponseAware.setServletResponse(this.response);
        }
    }

    private void servletRequestAware(Object object) {
        if (object instanceof ServletRequestAware) {
            ServletRequestAware servletRequestAware = (ServletRequestAware)object;
            servletRequestAware.setServletRequest(this.request);
        }
    }

    private void servletContextAware(Object object) {
        if (object instanceof ServletContextAware) {
            ServletContextAware servletContextAware = (ServletContextAware)object;
            servletContextAware.setServletContext(this.context);
        }
    }

    private void parameterAware(Object object) {
        if (object instanceof ParameterAware) {
            ParameterAware parameterAware = (ParameterAware)object;
            parameterAware.setParameter(this.getParameterMap());
        }
    }

    private void applicationAware(Object object) {
        if (object instanceof ApplicationAware) {
            ApplicationAware applicationAware = (ApplicationAware)object;
            applicationAware.setApplication(this.getApplicationMap());
        }
    }

    public boolean validation(Object object) throws ValidationException {
        if (object instanceof ValidationAware) {
            ValidationAware validationAware = (ValidationAware)object;
            validationAware.validate();
            if (validationAware.getErrorsMap() == null) {
                throw new ValidationException("Validation Exception. Errors Map is null");
            }
            if (validationAware.getErrorsMap().size() > 0) {
                return false;
            }
        }
        return true;
    }
}

