package com.babukuma.util.dbunit;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;

import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.ext.oracle.OracleConnection;
import org.dbunit.ext.oracle.OracleDataTypeFactory;

/**
 * Oracle용 데이터 생성 클래스
 * @author BABUKUMA
 */
public class OracleDataCreator extends AbstractDataCreator {

    /**
     * @param classLocation JDBC Class Location
     * @param jdbcDriver JDBC Driver Name
     * @param url DB Connect URL
     * @param userID DB Connect User ID
     * @param password DB Connect User Password
     * @param schema 사용할 DB schema
     */
    public OracleDataCreator(String classLocation, String jdbcDriver,
        String url, String userID, String password, String schema) {
        super(classLocation, jdbcDriver, url, userID, password, schema);
    }

    /**
     * Oracle용 Connection을 얻어온다.
     * @return IDatabaseConnection
     */
    protected IDatabaseConnection getConnection() {
        IDatabaseConnection connection = null;
        try {
            File path = new File(getClassLocation());
            URL[] urls = new URL[] {path.toURL()};

            ClassLoader cl = new URLClassLoader(urls);

            // DriverManager.registerDriver((Driver)
            // cl.loadClass(jdbcDriver).newInstance());
            Driver driver = (Driver) cl.loadClass(getJdbcDriver())
                .newInstance();
            Properties prop = new Properties();
            prop.put("user", getUserID());
            prop.put("password", getPassword());
            Connection jdbcConnection = driver.connect(getUrl(), prop);

            // Class.forName(jdbcDriver);
            //
            // Connection jdbcConnection = DriverManager.getConnection(url,
            // userID, password);
            //
            connection = new OracleConnection(jdbcConnection, getSchema());
            DatabaseConfig config = connection.getConfig();
            config.setProperty(DatabaseConfig.PROPERTY_DATATYPE_FACTORY,
                new OracleDataTypeFactory());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return connection;
    }
}
