/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.AbstractResultSetTable;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;

public class ForwardOnlyResultSetTable
extends AbstractResultSetTable {
    private int _lastRow = -1;
    private boolean _eot = false;

    public ForwardOnlyResultSetTable(ITableMetaData metaData, ResultSet resultSet) throws SQLException, DataSetException {
        super(metaData, resultSet);
    }

    public ForwardOnlyResultSetTable(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(metaData, connection);
    }

    public ForwardOnlyResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(tableName, selectStatement, connection);
    }

    public int getRowCount() {
        throw new UnsupportedOperationException();
    }

    public Object getValue(int row, String columnName) throws DataSetException {
        try {
            while (!this._eot && row > this._lastRow) {
                this._eot = !this._resultSet.next();
                ++this._lastRow;
            }
            if (row < this._lastRow) {
                throw new UnsupportedOperationException("Cannot go backward!");
            }
            if (this._eot || row > this._lastRow) {
                this.close();
                throw new RowOutOfBoundsException(row + " > " + this._lastRow);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Column column = this._metaData.getColumns()[columnIndex];
            return column.getDataType().getSqlValue(columnIndex + 1, this._resultSet);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }
}

