package org.argosdic.speech;

import org.eclipse.jface.util.Assert;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.JavaClipAudioPlayer;
import com.sun.speech.freetts.en.us.CMUDiphoneVoice;
import com.sun.speech.freetts.en.us.CMULexicon;

/**
 * SpeechManager.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/13 08:32:23 $
 */
public class SpeechManager {
    private Voice voice;
    private static SpeechManager instance;

    private SpeechManager() {
        this.voice = new CMUDiphoneVoice();

        voice.setLexicon(new CMULexicon());
        voice.getFeatures().setString(
            Voice.DATABASE_NAME,
            "cmu_kal/diphone_units16.bin"); //$NON-NLS-1$
        voice.setAudioPlayer(new JavaClipAudioPlayer());

        voice.load();
    }

    public static SpeechManager getInstance() {
        if (instance == null) {
            synchronized (SpeechManager.class) {
                instance = new SpeechManager();
            }
        }
        return instance;
    }

    public void speak(String sentence) {
        Assert.isNotNull(sentence);
        voice.speak(sentence);
    }
}
