package org.argosdic.preference;

import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * DictionaryPreferencePage.java
 * @author Xavier Cho
 * @version $Revision: 1.4 $ $Date: 2003/10/12 11:26:51 $
 */
public class DictionaryPreferencePage extends FieldEditorPreferencePage {
    public final static String NAME = "Dictionary"; //$NON-NLS-1$

    public DictionaryPreferencePage() {
        super(FieldEditorPreferencePage.GRID);
    }

    public DictionaryPreferencePage(String title) {
        super(title, FieldEditorPreferencePage.GRID);
    }

    public DictionaryPreferencePage(String title, ImageDescriptor image) {
        super(title, image, FieldEditorPreferencePage.GRID);
    }

    /**
     * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
     */
    protected void createFieldEditors() {
        ResourceManager resources = ResourceManager.getInstance();

        addField(new DirectoryFieldEditor("data.dir", //$NON-NLS-1$
        resources.getString("label.preferences.dataDir"), //$NON-NLS-1$
        getFieldEditorParent()));
        addField(new FontFieldEditor("browser.font", //$NON-NLS-1$
        resources.getString("label.preferences.font"), //$NON-NLS-1$
        getFieldEditorParent()));

        IntegerFieldEditor intEditor =
            new IntegerFieldEditor(
                "wildcard.query.threshold", //$NON-NLS-1$
                resources.getString("label.preferences.wildcard"), //$NON-NLS-1$
                getFieldEditorParent());

        intEditor.setValidRange(1, Integer.MAX_VALUE);
        addField(intEditor);

        /*
        intEditor =
            new IntegerFieldEditor(
                "word.completion.threshold", //$NON-NLS-1$
                resources.getString("label.preferences.completion"), //$NON-NLS-1$
                getFieldEditorParent());

        intEditor.setValidRange(1, Integer.MAX_VALUE);
        addField(intEditor);*/
    }
}
