/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;

public final class RAMDirectory
extends Directory {
    Hashtable files = new Hashtable();

    public RAMDirectory() {
    }

    public RAMDirectory(Directory dir) throws IOException {
        String[] ar = dir.list();
        int i = 0;
        while (i < ar.length) {
            OutputStream os = this.createFile(ar[i]);
            InputStream is = dir.openFile(ar[i]);
            int len = (int)is.length();
            byte[] buf = new byte[len];
            is.readBytes(buf, 0, len);
            os.writeBytes(buf, len);
            is.close();
            os.close();
            ++i;
        }
    }

    public RAMDirectory(File dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false));
    }

    public RAMDirectory(String dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false));
    }

    public final String[] list() {
        String[] result = new String[this.files.size()];
        int i = 0;
        Enumeration names = this.files.keys();
        while (names.hasMoreElements()) {
            result[i++] = (String)names.nextElement();
        }
        return result;
    }

    public final boolean fileExists(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file != null;
    }

    public final long fileModified(String name) throws IOException {
        RAMFile file = (RAMFile)this.files.get(name);
        return file.lastModified;
    }

    public void touchFile(String name) throws IOException {
        RAMFile file = (RAMFile)this.files.get(name);
        file.lastModified = System.currentTimeMillis();
    }

    public final long fileLength(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file.length;
    }

    public final void deleteFile(String name) {
        this.files.remove(name);
    }

    public final void renameFile(String from, String to) {
        RAMFile file = (RAMFile)this.files.get(from);
        this.files.remove(from);
        this.files.put(to, file);
    }

    public final OutputStream createFile(String name) {
        RAMFile file = new RAMFile();
        this.files.put(name, file);
        return new RAMOutputStream(file);
    }

    public final InputStream openFile(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return new RAMInputStream(file);
    }

    public final Lock makeLock(final String name) {
        return new Lock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean obtain() throws IOException {
                Hashtable hashtable = RAMDirectory.this.files;
                synchronized (hashtable) {
                    if (!RAMDirectory.this.fileExists(name)) {
                        RAMDirectory.this.createFile(name).close();
                        return true;
                    }
                    return false;
                }
            }

            public void release() {
                RAMDirectory.this.deleteFile(name);
            }

            public boolean isLocked() {
                return RAMDirectory.this.fileExists(name);
            }
        };
    }

    public final void close() {
    }
}

