/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = Transfer.registerType("text/uri-list");
    private static final String URI_LIST_PREFIX = "file:";
    private static final String URI_LIST_SEPARATOR = "\r";

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (object == null || !(object instanceof String[])) {
            return;
        }
        String[] files = (String[])object;
        if (files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int length = files.length;
        while (i < length) {
            sb.append(URI_LIST_PREFIX);
            sb.append(files[i]);
            sb.append(URI_LIST_SEPARATOR);
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, sb.toString(), true);
        int pValue = OS.g_malloc((int)buffer.length);
        if (pValue == 0) {
            return;
        }
        OS.memmove((int)pValue, (byte[])buffer, (int)buffer.length);
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int size = transferData.format * transferData.length / 8;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[size];
        OS.memmove((byte[])buffer, (int)transferData.pValue, (int)size);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        String string = new String(chars);
        int start = string.indexOf(URI_LIST_PREFIX);
        if (start == -1) {
            return null;
        }
        start += URI_LIST_PREFIX.length();
        String[] fileNames = new String[]{};
        while (start < string.length()) {
            int end = string.indexOf(URI_LIST_SEPARATOR, start);
            if (end == -1) {
                end = string.length() - 1;
            }
            String fileName = string.substring(start, end);
            String[] newFileNames = new String[fileNames.length + 1];
            System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
            newFileNames[fileNames.length] = fileName;
            fileNames = newFileNames;
            start = string.indexOf(URI_LIST_PREFIX, end);
            if (start == -1) break;
            start += URI_LIST_PREFIX.length();
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST};
    }
}

