/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static int GTKCLIPBOARD = OS.gtk_clipboard_get((int)0);
    static int GTKPRIMARYCLIPBOARD;
    private static int TARGET;
    static /* synthetic */ Class class$0;

    static {
        byte[] buffer = Converter.wcsToMbcs(null, "PRIMARY", true);
        int primary = OS.gdk_atom_intern((byte[])buffer, (boolean)false);
        GTKPRIMARYCLIPBOARD = OS.gtk_clipboard_get((int)primary);
        buffer = Converter.wcsToMbcs(null, "TARGETS", true);
        TARGET = OS.gdk_atom_intern((byte[])buffer, (boolean)false);
    }

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.swt.dnd.Clipboard;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void dispose() {
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        int selection_data = 0;
        int[] typeIds = transfer.getTypeIds();
        int i = 0;
        while (i < typeIds.length) {
            selection_data = OS.gtk_clipboard_wait_for_contents((int)GTKPRIMARYCLIPBOARD, (int)typeIds[i]);
            if (selection_data != 0) break;
            ++i;
        }
        if (selection_data == 0) {
            i = 0;
            while (i < typeIds.length) {
                selection_data = OS.gtk_clipboard_wait_for_contents((int)GTKCLIPBOARD, (int)typeIds[i]);
                if (selection_data != 0) break;
                ++i;
            }
        }
        if (selection_data == 0) {
            return null;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)24);
        TransferData tdata = new TransferData();
        tdata.type = gtkSelectionData.target;
        tdata.pValue = gtkSelectionData.data;
        tdata.length = gtkSelectionData.length;
        tdata.format = gtkSelectionData.format;
        Object result = transfer.nativeToJava(tdata);
        OS.gtk_selection_data_free((int)selection_data);
        return result;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        if (dataTypes.length == 0) {
            return;
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        if (!proxy.setData(data, dataTypes)) {
            DND.error(2002);
        }
    }

    public TransferData[] getAvailableTypes() {
        this.checkWidget();
        int[] types = this._getAvailableTypes();
        TransferData[] result = new TransferData[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = new TransferData();
            result[i].type = types[i];
            ++i;
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        int[] types = this._getAvailableTypes();
        String[] result = new String[types.length];
        int i = 0;
        while (i < types.length) {
            int pName = OS.gdk_atom_name((int)types[i]);
            byte[] buffer = new byte[OS.strlen((int)pName)];
            OS.memmove((byte[])buffer, (int)pName, (int)buffer.length);
            OS.g_free((int)pName);
            result[i] = new String(Converter.mbcsToWcs(null, buffer));
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] _getAvailableTypes() {
        int selection_data;
        int[] types;
        block12: {
            int[] nArray;
            block11: {
                GtkSelectionData gtkSelectionData;
                types = new int[]{};
                selection_data = OS.gtk_clipboard_wait_for_contents((int)GTKPRIMARYCLIPBOARD, (int)TARGET);
                if (selection_data != 0) {
                    block10: {
                        int[] nArray2;
                        block9: {
                            try {
                                gtkSelectionData = new GtkSelectionData();
                                OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)24);
                                if (gtkSelectionData.length == 0) {
                                    nArray2 = types;
                                    Object var4_8 = null;
                                    break block9;
                                }
                                types = new int[gtkSelectionData.length * 8 / gtkSelectionData.format];
                                OS.memmove((int[])types, (int)gtkSelectionData.data, (int)gtkSelectionData.length);
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var4_9 = null;
                                OS.gtk_selection_data_free((int)selection_data);
                                throw throwable;
                            }
                        }
                        OS.gtk_selection_data_free((int)selection_data);
                        return nArray2;
                    }
                    Object var4_10 = null;
                    OS.gtk_selection_data_free((int)selection_data);
                }
                if ((selection_data = OS.gtk_clipboard_wait_for_contents((int)GTKCLIPBOARD, (int)TARGET)) == 0) return types;
                try {
                    gtkSelectionData = new GtkSelectionData();
                    OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)24);
                    if (gtkSelectionData.length == 0) {
                        nArray = types;
                        Object var6_5 = null;
                        break block11;
                    }
                    int[] temp = new int[gtkSelectionData.length * 8 / gtkSelectionData.format];
                    OS.memmove((int[])temp, (int)gtkSelectionData.data, (int)gtkSelectionData.length);
                    int[] newTypes = new int[types.length + temp.length];
                    System.arraycopy(types, 0, newTypes, 0, types.length);
                    System.arraycopy(temp, 0, newTypes, types.length, temp.length);
                    types = newTypes;
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OS.gtk_selection_data_free((int)selection_data);
                    throw throwable;
                }
            }
            OS.gtk_selection_data_free((int)selection_data);
            return nArray;
        }
        Object var6_7 = null;
        OS.gtk_selection_data_free((int)selection_data);
        return types;
    }
}

