/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleType;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class AccessibleObject {
    int handle;
    int parentType;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    Hashtable children = new Hashtable(9);
    boolean isLightweight = false;
    int actionNamePtr = -1;
    int descriptionPtr = -1;
    int keybindingPtr = -1;
    int namePtr = -1;
    static boolean DEBUG = Display.DEBUG;

    AccessibleObject(int type, int widget, Accessible accessible, int parentType, boolean isLightweight) {
        this.handle = ATK.g_object_new((int)type, (int)0);
        this.parentType = parentType;
        ATK.atk_object_initialize((int)this.handle, (int)widget);
        this.accessible = accessible;
        this.isLightweight = isLightweight;
        if (DEBUG) {
            System.out.println("new AccessibleObject: " + this.handle);
        }
    }

    void addChild(AccessibleObject child) {
        this.children.put(new Integer(child.handle), child);
        child.setParent(this);
    }

    int atkAction_get_keybinding(int index) {
        AccessibleListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_ACTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_ACTION_GET_IFACE((int)this.handle));
            AtkActionIface actionIface = new AtkActionIface();
            ATK.memmove((AtkActionIface)actionIface, (int)superType);
            if (actionIface.get_keybinding != 0) {
                parentResult = ATK.call((int)actionIface.get_keybinding, (int)this.handle, (int)index);
            }
        }
        if ((listeners = this.accessible.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = this.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getKeyboardShortcut(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (this.keybindingPtr != -1) {
            OS.g_free((int)this.keybindingPtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        this.keybindingPtr = OS.g_malloc((int)name.length);
        OS.memmove((int)this.keybindingPtr, (byte[])name, (int)name.length);
        return this.keybindingPtr;
    }

    int atkAction_get_name(int index) {
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_ACTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_ACTION_GET_IFACE((int)this.handle));
            AtkActionIface actionIface = new AtkActionIface();
            ATK.memmove((AtkActionIface)actionIface, (int)superType);
            if (actionIface.get_name != 0) {
                parentResult = ATK.call((int)actionIface.get_name, (int)this.handle, (int)index);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getDefaultAction(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (this.actionNamePtr != -1) {
            OS.g_free((int)this.actionNamePtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        this.actionNamePtr = OS.g_malloc((int)name.length);
        OS.memmove((int)this.actionNamePtr, (byte[])name, (int)name.length);
        return this.actionNamePtr;
    }

    int atkComponent_get_extents(int x, int y, int width, int height, int coord_type) {
        int[] topWindowY;
        int[] topWindowX;
        int window;
        int topLevel;
        GtkAccessible gtkAccessible;
        int gtkAccessibleHandle;
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)this.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.get_extents != 0) {
                parentResult = ATK.call((int)componentIface.get_extents, (int)this.handle, (int)x, (int)y, (int)width, (int)height, (int)coord_type);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        int[] parentX = new int[1];
        int[] parentY = new int[1];
        int[] parentWidth = new int[1];
        int[] parentHeight = new int[1];
        OS.memmove((int[])parentX, (int)x, (int)4);
        OS.memmove((int[])parentY, (int)y, (int)4);
        OS.memmove((int[])parentWidth, (int)width, (int)4);
        OS.memmove((int[])parentHeight, (int)height, (int)4);
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.x = parentX[0];
        event.y = parentY[0];
        event.width = parentWidth[0];
        event.height = parentHeight[0];
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)this.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getLocation(event);
            ++i;
        }
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)this.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x -= topWindowX[0];
            event.y -= topWindowY[0];
        }
        OS.memmove((int)x, (int[])new int[]{event.x}, (int)4);
        OS.memmove((int)y, (int[])new int[]{event.y}, (int)4);
        OS.memmove((int)width, (int[])new int[]{event.width}, (int)4);
        OS.memmove((int)height, (int[])new int[]{event.height}, (int)4);
        return 0;
    }

    int atkComponent_get_position(int x, int y, int coord_type) {
        int[] topWindowY;
        int[] topWindowX;
        int window;
        int topLevel;
        GtkAccessible gtkAccessible;
        int gtkAccessibleHandle;
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)this.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.get_extents != 0) {
                parentResult = ATK.call((int)componentIface.get_position, (int)this.handle, (int)x, (int)y, (int)coord_type);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        int[] parentX = new int[1];
        int[] parentY = new int[1];
        OS.memmove((int[])parentX, (int)x, (int)4);
        OS.memmove((int[])parentY, (int)y, (int)4);
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.x = parentX[0];
        event.y = parentY[0];
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)this.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getLocation(event);
            ++i;
        }
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)this.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x -= topWindowX[0];
            event.y -= topWindowY[0];
        }
        OS.memmove((int)x, (int[])new int[]{event.x}, (int)4);
        OS.memmove((int)y, (int[])new int[]{event.y}, (int)4);
        return 0;
    }

    int atkComponent_get_size(int width, int height, int coord_type) {
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)this.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.get_extents != 0) {
                parentResult = ATK.call((int)componentIface.get_size, (int)this.handle, (int)width, (int)height, (int)coord_type);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        int[] parentWidth = new int[1];
        int[] parentHeight = new int[1];
        OS.memmove((int[])parentWidth, (int)width, (int)4);
        OS.memmove((int[])parentHeight, (int)height, (int)4);
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.width = parentWidth[0];
        event.height = parentHeight[0];
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getLocation(event);
            ++i;
        }
        OS.memmove((int)width, (int[])new int[]{event.width}, (int)4);
        OS.memmove((int)height, (int[])new int[]{event.height}, (int)4);
        return 0;
    }

    int atkComponent_ref_accessible_at_point(int x, int y, int coord_type) {
        AccessibleObject accObj;
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)this.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.ref_accessible_at_point != 0) {
                parentResult = ATK.call((int)componentIface.ref_accessible_at_point, (int)this.handle, (int)x, (int)y, (int)coord_type);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.x = x;
        event.y = y;
        if (coord_type == 1) {
            int gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)this.handle);
            GtkAccessible gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            int topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            int window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            int[] topWindowX = new int[1];
            int[] topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getChildAtPoint(event);
            ++i;
        }
        if (event.childID == this.id) {
            event.childID = -1;
        }
        if ((accObj = this.getChildByID(event.childID)) != null) {
            if (parentResult > 0) {
                OS.g_object_unref((int)parentResult);
            }
            OS.g_object_ref((int)accObj.handle);
            return accObj.handle;
        }
        return parentResult;
    }

    int atkObject_get_description() {
        AccessibleListener[] listeners;
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_description != 0) {
            parentResult = ATK.call((int)objectClass.get_description, (int)this.handle);
        }
        if ((listeners = this.accessible.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = this.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getDescription(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (this.descriptionPtr != -1) {
            OS.g_free((int)this.descriptionPtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        this.descriptionPtr = OS.g_malloc((int)name.length);
        OS.memmove((int)this.descriptionPtr, (byte[])name, (int)name.length);
        return this.descriptionPtr;
    }

    int atkObject_get_name() {
        AccessibleListener[] listeners;
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_name != 0) {
            parentResult = ATK.call((int)objectClass.get_name, (int)this.handle);
        }
        if ((listeners = this.accessible.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = this.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getName(event);
            ++i;
        }
        if (event.result == null) {
            return parentResult;
        }
        if (this.namePtr != -1) {
            OS.g_free((int)this.namePtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        this.namePtr = OS.g_malloc((int)name.length);
        OS.memmove((int)this.namePtr, (byte[])name, (int)name.length);
        return this.namePtr;
    }

    int atkObject_get_n_children() {
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_n_children != 0) {
            parentResult = ATK.call((int)objectClass.get_n_children, (int)this.handle);
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.detail = parentResult;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getChildCount(event);
            ++i;
        }
        return event.detail;
    }

    int atkObject_get_index_in_parent() {
        if (this.index != -1) {
            return this.index;
        }
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_index_in_parent == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.get_index_in_parent, (int)this.handle);
    }

    int atkObject_get_parent() {
        if (this.parent != null) {
            return this.parent.handle;
        }
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_parent == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.get_parent, (int)this.handle);
    }

    int atkObject_get_role() {
        if (this.accessible.getAccessibleListeners().length != 0) {
            AccessibleControlListener[] listeners = this.accessible.getControlListeners();
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = this.id;
            event.detail = -1;
            int i = 0;
            while (i < listeners.length) {
                listeners[i].getRole(event);
                ++i;
            }
            if (event.detail != -1) {
                switch (event.detail) {
                    case 44: {
                        return 7;
                    }
                    case 10: {
                        return 18;
                    }
                    case 46: {
                        return 11;
                    }
                    case 18: {
                        return 16;
                    }
                    case 41: {
                        return 28;
                    }
                    case 33: {
                        return 30;
                    }
                    case 34: {
                        return 31;
                    }
                    case 11: {
                        return 32;
                    }
                    case 2: {
                        return 33;
                    }
                    case 12: {
                        return 34;
                    }
                    case 48: {
                        return 41;
                    }
                    case 43: {
                        return 42;
                    }
                    case 3: {
                        return 47;
                    }
                    case 21: {
                        return 49;
                    }
                    case 51: {
                        return 50;
                    }
                    case 24: {
                        return 54;
                    }
                    case 60: {
                        return 37;
                    }
                    case 25: {
                        return 56;
                    }
                    case 37: {
                        return 36;
                    }
                    case 42: {
                        return 60;
                    }
                    case 22: {
                        return 62;
                    }
                    case 13: {
                        return 63;
                    }
                    case 35: {
                        return 64;
                    }
                    case 45: {
                        return 43;
                    }
                    case 9: {
                        return 68;
                    }
                }
            }
        }
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_role == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.get_role, (int)this.handle);
    }

    int atkObject_ref_child(int index) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByIndex(index);
        if (accObject != null) {
            OS.g_object_ref((int)accObject.handle);
            return accObject.handle;
        }
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.ref_child == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.ref_child, (int)this.handle, (int)index);
    }

    int atkObject_ref_state_set() {
        if (this.accessible.getControlListeners().length != 0) {
            int set = ATK.atk_state_set_new();
            AccessibleControlListener[] listeners = this.accessible.getControlListeners();
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = this.id;
            event.detail = -1;
            int i = 0;
            while (i < listeners.length) {
                listeners[i].getState(event);
                ++i;
            }
            if (event.detail != -1) {
                int state = event.detail;
                if ((state & 0x800) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)3);
                }
                if ((state & 0x10) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)4);
                }
                if ((state & 0x200) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)9);
                }
                if ((state & 0x100000) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)10);
                }
                if ((state & 4) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)11);
                }
                if ((state & 0x80) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)2);
                }
                if ((state & 0x8000) == 0) {
                    ATK.atk_state_set_add_state((int)set, (int)28);
                }
                if ((state & 0x1000000) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)16);
                }
                if ((state & 0x10000) == 0) {
                    ATK.atk_state_set_add_state((int)set, (int)23);
                }
                if ((state & 8) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)18);
                }
                if ((state & 0x40) == 0) {
                    ATK.atk_state_set_add_state((int)set, (int)6);
                }
                if ((state & 0x200000) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)20);
                }
                if ((state & 2) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)21);
                }
                if ((state & 0x20000) != 0) {
                    ATK.atk_state_set_add_state((int)set, (int)19);
                }
                return set;
            }
        }
        int superType = ATK.g_type_class_peek((int)this.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.ref_state_set == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.ref_state_set, (int)this.handle);
    }

    int atkSelection_is_child_selected(int index) {
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_SELECTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_SELECTION_GET_IFACE((int)this.handle));
            AtkSelectionIface selectionIface = new AtkSelectionIface();
            ATK.memmove((AtkSelectionIface)selectionIface, (int)superType);
            if (selectionIface.is_child_selected != 0) {
                parentResult = ATK.call((int)selectionIface.is_child_selected, (int)this.handle, (int)index);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getSelection(event);
            ++i;
        }
        AccessibleObject accessibleObject = this.getChildByID(event.childID);
        if (accessibleObject != null) {
            return accessibleObject.index == index ? 1 : 0;
        }
        return parentResult;
    }

    int atkSelection_ref_selection(int index) {
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_SELECTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_SELECTION_GET_IFACE((int)this.handle));
            AtkSelectionIface selectionIface = new AtkSelectionIface();
            ATK.memmove((AtkSelectionIface)selectionIface, (int)superType);
            if (selectionIface.ref_selection != 0) {
                parentResult = ATK.call((int)selectionIface.ref_selection, (int)this.handle, (int)index);
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getSelection(event);
            ++i;
        }
        AccessibleObject accObj = this.getChildByID(event.childID);
        if (accObj != null) {
            if (parentResult > 0) {
                OS.g_object_unref((int)parentResult);
            }
            OS.g_object_ref((int)accObj.handle);
            return accObj.handle;
        }
        return parentResult;
    }

    int atkText_get_character_at_offset(int offset) {
        String text = this.getText();
        if (text != null) {
            return text.charAt(offset);
        }
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)this.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_character_at_offset != 0) {
                return ATK.call((int)textIface.get_character_at_offset, (int)this.handle, (int)offset);
            }
        }
        return 0;
    }

    int atkText_get_character_count() {
        if (this.accessible.control.isDisposed()) {
            return 0;
        }
        String text = this.getText();
        if (text != null) {
            return text.length();
        }
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)this.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_character_count != 0) {
                return ATK.call((int)textIface.get_character_count, (int)this.handle);
            }
        }
        return 0;
    }

    int atkText_get_text(int start_offset, int end_offset) {
        String text = this.getText();
        if (text != null) {
            end_offset = end_offset == -1 ? text.length() : Math.min(end_offset, text.length());
            start_offset = Math.min(start_offset, end_offset);
            text = text.substring(start_offset, end_offset);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)this.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_text != 0) {
                return ATK.call((int)textIface.get_text, (int)this.handle, (int)start_offset, (int)end_offset);
            }
        }
        return 0;
    }

    int atkText_get_text_after_offset(int offset, int boundary_type, int start_offset, int end_offset) {
        String text = this.getText();
        if (text != null) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch (boundary_type) {
                case 0: {
                    if (length <= offset) break;
                    break;
                }
                case 1: {
                    int wordStart1 = this.nextIndexOfChar(text, " !?.\n", offset - 1);
                    if (wordStart1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordStart1 = this.nextIndexOfNotChar(text, " !?.\n", wordStart1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = wordStart1;
                    int wordStart2 = this.nextIndexOfChar(text, " !?.\n", wordStart1);
                    if (wordStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = this.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                    break;
                }
                case 2: {
                    int previousWordEnd = this.previousIndexOfNotChar(text, " \n", offset);
                    if (previousWordEnd == -1 || previousWordEnd != offset - 1) {
                        offset = this.nextIndexOfNotChar(text, " \n", offset);
                    }
                    if (offset == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    int wordEnd1 = this.nextIndexOfChar(text, " !?.\n", offset);
                    if (wordEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordEnd1 = this.nextIndexOfNotChar(text, "!?.", wordEnd1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = wordEnd1;
                    int wordEnd2 = this.nextIndexOfNotChar(text, " \n", wordEnd1);
                    if (wordEnd2 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordEnd2 = this.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = this.nextIndexOfNotChar(text, "!?.", wordEnd2);
                    break;
                }
                case 3: {
                    int previousSentenceEnd = this.previousIndexOfChar(text, "!?.", offset);
                    int previousText = this.previousIndexOfNotChar(text, " !?.\n", offset);
                    int sentenceStart1 = 0;
                    if (previousSentenceEnd >= previousText) {
                        sentenceStart1 = this.nextIndexOfNotChar(text, " !?.\n", offset);
                    } else {
                        sentenceStart1 = this.nextIndexOfChar(text, "!?.", offset);
                        if (sentenceStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        sentenceStart1 = this.nextIndexOfNotChar(text, " !?.\n", sentenceStart1);
                    }
                    if (sentenceStart1 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = sentenceStart1;
                    int sentenceStart2 = this.nextIndexOfChar(text, "!?.", sentenceStart1);
                    if (sentenceStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = this.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                    break;
                }
                case 4: {
                    int sentenceEnd1 = this.nextIndexOfChar(text, "!?.", offset);
                    if (sentenceEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((sentenceEnd1 = this.nextIndexOfNotChar(text, "!?.", sentenceEnd1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = sentenceEnd1;
                    int sentenceEnd2 = this.nextIndexOfNotChar(text, " \n", sentenceEnd1);
                    if (sentenceEnd2 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((sentenceEnd2 = this.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = this.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                    break;
                }
                case 5: {
                    int lineStart1 = text.indexOf(10, offset - 1);
                    if (lineStart1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((lineStart1 = this.nextIndexOfNotChar(text, "\n", lineStart1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = lineStart1;
                    int lineStart2 = text.indexOf(10, lineStart1);
                    if (lineStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = lineStart2 = this.nextIndexOfNotChar(text, "\n", lineStart2);
                    break;
                }
                case 6: {
                    int lineEnd2;
                    int lineEnd1 = this.nextIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = lineEnd1;
                    endBounds = startBounds == length ? length : ((lineEnd2 = this.nextIndexOfChar(text, "\n", lineEnd1 + 1)) == -1 ? length : lineEnd2);
                }
            }
            OS.memmove((int)start_offset, (int[])new int[]{startBounds}, (int)4);
            OS.memmove((int)end_offset, (int[])new int[]{++endBounds}, (int)4);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)this.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_text_after_offset != 0) {
                return ATK.call((int)textIface.get_text_after_offset, (int)this.handle, (int)offset, (int)boundary_type, (int)start_offset, (int)end_offset);
            }
        }
        return 0;
    }

    int atkText_get_text_at_offset(int offset, int boundary_type, int start_offset, int end_offset) {
        String text = this.getText();
        if (text != null) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch (boundary_type) {
                case 0: {
                    if (length <= offset) break;
                    break;
                }
                case 1: {
                    int wordStart1 = this.previousIndexOfNotChar(text, " !?.\n", offset);
                    if (wordStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((wordStart1 = this.previousIndexOfChar(text, " !?.\n", wordStart1) + 1) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = wordStart1;
                    int wordStart2 = this.nextIndexOfChar(text, " !?.\n", wordStart1);
                    endBounds = this.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                    break;
                }
                case 2: {
                    int wordEnd1 = this.previousIndexOfNotChar(text, "!?.", offset + 1);
                    wordEnd1 = this.previousIndexOfChar(text, " !?.\n", wordEnd1);
                    wordEnd1 = this.previousIndexOfNotChar(text, " \n", wordEnd1 + 1);
                    if (wordEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = wordEnd1 + 1;
                    int wordEnd2 = this.nextIndexOfNotChar(text, " \n", startBounds);
                    if (wordEnd2 == length) {
                        endBounds = startBounds;
                        break;
                    }
                    if ((wordEnd2 = this.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        endBounds = startBounds;
                        break;
                    }
                    endBounds = this.nextIndexOfNotChar(text, "!?.", wordEnd2);
                    break;
                }
                case 3: {
                    int sentenceStart1 = this.previousIndexOfNotChar(text, " !?.\n", offset + 1);
                    if (sentenceStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    sentenceStart1 = this.previousIndexOfChar(text, "!?.", sentenceStart1) + 1;
                    startBounds = this.nextIndexOfNotChar(text, " \n", sentenceStart1);
                    int sentenceStart2 = this.nextIndexOfChar(text, "!?.", startBounds);
                    endBounds = this.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                    break;
                }
                case 4: {
                    int sentenceEnd1 = this.previousIndexOfNotChar(text, "!?.", offset + 1);
                    sentenceEnd1 = this.previousIndexOfChar(text, "!?.", sentenceEnd1);
                    sentenceEnd1 = this.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1);
                    if (sentenceEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = sentenceEnd1 + 1;
                    int sentenceEnd2 = this.nextIndexOfNotChar(text, " \n", startBounds);
                    if (sentenceEnd2 == length) {
                        endBounds = startBounds;
                        break;
                    }
                    if ((sentenceEnd2 = this.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        endBounds = startBounds;
                        break;
                    }
                    endBounds = this.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                    break;
                }
                case 5: {
                    startBounds = this.previousIndexOfChar(text, "\n", offset) + 1;
                    int lineEnd2 = this.nextIndexOfChar(text, "\n", startBounds);
                    if (lineEnd2 < length) {
                        ++lineEnd2;
                    }
                    endBounds = lineEnd2;
                    break;
                }
                case 6: {
                    int lineEnd1 = this.previousIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = lineEnd1;
                    endBounds = this.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                }
            }
            OS.memmove((int)start_offset, (int[])new int[]{startBounds}, (int)4);
            OS.memmove((int)end_offset, (int[])new int[]{++endBounds}, (int)4);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)this.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_text_after_offset != 0) {
                return ATK.call((int)textIface.get_text_after_offset, (int)this.handle, (int)offset, (int)boundary_type, (int)start_offset, (int)end_offset);
            }
        }
        return 0;
    }

    int atkText_get_text_before_offset(int offset, int boundary_type, int start_offset, int end_offset) {
        String text = this.getText();
        if (text != null) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch (boundary_type) {
                case 0: {
                    if (length < offset || offset <= 0) break;
                    break;
                }
                case 1: {
                    int wordStart1 = this.previousIndexOfChar(text, " !?.\n", offset - 1);
                    if (wordStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    int wordStart2 = this.previousIndexOfNotChar(text, " !?.\n", wordStart1);
                    if (wordStart2 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = wordStart1 + 1;
                    startBounds = this.previousIndexOfChar(text, " !?.\n", wordStart2) + 1;
                    break;
                }
                case 2: {
                    int wordEnd1 = this.previousIndexOfChar(text, " !?.\n", offset);
                    if (wordEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((wordEnd1 = this.previousIndexOfNotChar(text, " \n", wordEnd1 + 1)) == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = wordEnd1 + 1;
                    int wordEnd2 = this.previousIndexOfNotChar(text, " !?.\n", endBounds);
                    if ((wordEnd2 = this.previousIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = this.previousIndexOfNotChar(text, " \n", wordEnd2 + 1) + 1;
                    break;
                }
                case 3: {
                    int sentenceStart1 = this.previousIndexOfChar(text, "!?.", offset);
                    if (sentenceStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    int sentenceStart2 = this.previousIndexOfNotChar(text, "!?.", sentenceStart1);
                    if (sentenceStart2 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = sentenceStart1 + 1;
                    startBounds = this.previousIndexOfChar(text, "!?.", sentenceStart2) + 1;
                    break;
                }
                case 4: {
                    int sentenceEnd1 = this.previousIndexOfChar(text, "!?.", offset);
                    if (sentenceEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((sentenceEnd1 = this.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1)) == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = sentenceEnd1 + 1;
                    int sentenceEnd2 = this.previousIndexOfNotChar(text, "!?.", endBounds);
                    if ((sentenceEnd2 = this.previousIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = this.previousIndexOfNotChar(text, " \n", sentenceEnd2 + 1) + 1;
                    break;
                }
                case 5: {
                    int lineStart1 = this.previousIndexOfChar(text, "\n", offset);
                    if (lineStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = lineStart1 + 1;
                    startBounds = this.previousIndexOfChar(text, "\n", lineStart1) + 1;
                    break;
                }
                case 6: {
                    int lineEnd1 = this.previousIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = lineEnd1;
                    startBounds = this.previousIndexOfChar(text, "\n", lineEnd1);
                    if (startBounds != -1) break;
                    startBounds = 0;
                }
            }
            OS.memmove((int)start_offset, (int[])new int[]{--startBounds}, (int)4);
            OS.memmove((int)end_offset, (int[])new int[]{endBounds}, (int)4);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)this.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_text_before_offset != 0) {
                return ATK.call((int)textIface.get_text_before_offset, (int)this.handle, (int)offset, (int)boundary_type, (int)start_offset, (int)end_offset);
            }
        }
        return 0;
    }

    void dispose() {
        if (DEBUG) {
            System.out.println("AccessibleObject.dispose: " + this.handle);
        }
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject child = (AccessibleObject)elements.nextElement();
            if (!child.isLightweight) continue;
            OS.g_object_unref((int)child.handle);
        }
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
        if (this.namePtr != -1) {
            OS.g_free((int)this.namePtr);
        }
        this.namePtr = -1;
        if (this.descriptionPtr != -1) {
            OS.g_free((int)this.descriptionPtr);
        }
        this.descriptionPtr = -1;
        if (this.keybindingPtr != -1) {
            OS.g_free((int)this.keybindingPtr);
        }
        this.keybindingPtr = -1;
        if (this.actionNamePtr != -1) {
            OS.g_free((int)this.actionNamePtr);
        }
        this.actionNamePtr = -1;
    }

    AccessibleObject getChildByHandle(int handle) {
        return (AccessibleObject)this.children.get(new Integer(handle));
    }

    AccessibleObject getChildByID(int childId) {
        if (childId == -1) {
            return this;
        }
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject object = (AccessibleObject)elements.nextElement();
            if (object.id != childId) continue;
            return object;
        }
        return null;
    }

    AccessibleObject getChildByIndex(int childIndex) {
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject object = (AccessibleObject)elements.nextElement();
            if (object.index != childIndex) continue;
            return object;
        }
        return null;
    }

    String getText() {
        AccessibleControlListener[] listeners;
        int parentResult = 0;
        String parentText = "";
        if (ATK.g_type_is_a((int)this.parentType, (int)AccessibleType.ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_TEXT_GET_IFACE((int)this.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            int characterCount = 0;
            if (textIface.get_character_count != 0) {
                characterCount = ATK.call((int)textIface.get_character_count, (int)this.handle);
            }
            if (characterCount > 0 && textIface.get_text != 0 && (parentResult = ATK.call((int)textIface.get_text, (int)this.handle, (int)0, (int)characterCount)) != 0) {
                int length = OS.strlen((int)parentResult);
                byte[] buffer = new byte[length];
                OS.memmove((byte[])buffer, (int)parentResult, (int)length);
                parentText = new String(Converter.mbcsToWcs(null, buffer));
            }
        }
        if ((listeners = this.accessible.getControlListeners()).length == 0) {
            return parentText;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.result = parentText;
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getValue(event);
            ++i;
        }
        return event.result;
    }

    int nextIndexOfChar(String string, String searchChars, int startIndex) {
        int result = string.length();
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.indexOf(current, startIndex);
            if (index != -1) {
                result = Math.min(result, index);
            }
            ++i;
        }
        return result;
    }

    int nextIndexOfNotChar(String string, String searchChars, int startIndex) {
        int length = string.length();
        int index = startIndex;
        while (index < length) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            ++index;
        }
        return index;
    }

    int previousIndexOfChar(String string, String searchChars, int startIndex) {
        int result = -1;
        if (startIndex < 0) {
            return result;
        }
        string = string.substring(0, startIndex);
        int i = 0;
        while (i < searchChars.length()) {
            char current = searchChars.charAt(i);
            int index = string.lastIndexOf(current);
            if (index != -1) {
                result = Math.max(result, index);
            }
            ++i;
        }
        return result;
    }

    int previousIndexOfNotChar(String string, String searchChars, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        int index = startIndex - 1;
        while (index >= 0) {
            char current = string.charAt(index);
            if (searchChars.indexOf(current) == -1) break;
            --index;
        }
        return index;
    }

    void removeChild(AccessibleObject child, boolean unref) {
        this.children.remove(new Integer(child.handle));
        if (unref && child.isLightweight) {
            OS.g_object_unref((int)child.handle);
        }
    }

    void setFocusToChild(int childId) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childId);
        if (accObject != null) {
            ATK.atk_focus_tracker_notify((int)accObject.handle);
        }
    }

    void setParent(AccessibleObject parent) {
        this.parent = parent;
    }

    void updateChildren() {
        if (this.isLightweight) {
            return;
        }
        AccessibleControlListener[] listeners = this.accessible.getControlListeners();
        if (listeners.length == 0) {
            return;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getChildren(event);
            ++i;
        }
        if (event.children != null && event.children.length > 0) {
            Hashtable childrenCopy = (Hashtable)this.children.clone();
            if (event.children[0] instanceof Integer) {
                AccessibleType childType = AccessibleFactory.getChildType();
                int i2 = 0;
                while (i2 < event.children.length) {
                    AccessibleObject object = this.getChildByIndex(i2);
                    if (object == null) {
                        object = new AccessibleObject(childType.handle, 0, this.accessible, childType.parentType, true);
                        AccessibleType.addInstance(object);
                        this.addChild(object);
                        object.index = i2;
                    }
                    try {
                        object.id = (Integer)event.children[i2];
                    }
                    catch (ClassCastException classCastException) {}
                    childrenCopy.remove(new Integer(object.handle));
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < event.children.length) {
                    AccessibleObject object = null;
                    try {
                        object = ((Accessible)event.children[i3]).accessibleObject;
                    }
                    catch (ClassCastException classCastException) {}
                    object.index = i3++;
                    childrenCopy.remove(new Integer(object.handle));
                }
            }
            Enumeration childrenToRemove = childrenCopy.elements();
            while (childrenToRemove.hasMoreElements()) {
                AccessibleObject object = (AccessibleObject)childrenToRemove.nextElement();
                this.removeChild(object, true);
            }
        }
    }
}

