/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.SelectableItemWidget;

abstract class SelectableItem
extends Item {
    protected static final int CHECKBOX_PADDING = 1;
    private SelectableItemWidget parent;
    private boolean isSelected = false;
    private boolean isChecked = false;
    private boolean isGrayed = false;

    SelectableItem(SelectableItemWidget parent, int style) {
        super(parent, style);
        this.setParent(parent);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        super.dispose();
        this.doDispose();
    }

    void doDispose() {
        this.setParent(null);
    }

    Point drawCheckbox(GC gc, Point position) {
        SelectableItemWidget parent = this.getSelectableParent();
        Image image = this.getGrayed() ? parent.getGrayUncheckedImage() : parent.getUncheckedImage();
        if (image != null) {
            Point imageExtent = parent.getCheckBoxExtent();
            int imageOffset = (parent.getItemHeight() - imageExtent.y) / 2;
            gc.drawImage(image, position.x, position.y + imageOffset);
            if (this.getChecked()) {
                image = parent.getCheckMarkImage();
                Rectangle imageBounds = image.getBounds();
                int xInset = (imageExtent.x - imageBounds.width) / 2;
                int yInset = (imageExtent.y - imageBounds.height) / 2;
                gc.drawImage(image, position.x + xInset, position.y + imageOffset + yInset);
            }
            position.x += imageExtent.x;
        }
        ++position.x;
        return position;
    }

    void drawInsertMark(GC gc, Point position) {
        SelectableItemWidget parent = this.getSelectableParent();
        Point selectionExtent = this.getSelectionExtent();
        int markerWidth = this.getInsertMarkWidth();
        int insertMarkYOffset = 0;
        if (selectionExtent == null) {
            return;
        }
        if (parent.isInsertAfter()) {
            insertMarkYOffset = selectionExtent.y - markerWidth;
        }
        gc.setBackground(this.getDisplay().getSystemColor(2));
        gc.fillRectangle(position.x, position.y + insertMarkYOffset, selectionExtent.x, markerWidth);
        gc.setBackground(parent.getBackground());
    }

    Rectangle getCheckboxBounds() {
        SelectableItemWidget parent = this.getSelectableParent();
        Rectangle checkboxBounds = new Rectangle(0, 0, 0, 0);
        if (this.isCheckable()) {
            checkboxBounds.x = this.getCheckboxXPosition();
            int redrawPosition = parent.getRedrawY(this);
            if (redrawPosition != -1) {
                checkboxBounds.y = redrawPosition;
            }
            Point checkBoxExtent = parent.getCheckBoxExtent();
            checkboxBounds.width = checkBoxExtent.x;
            checkboxBounds.height = checkBoxExtent.y;
            checkboxBounds.y += (parent.getItemHeight() - checkBoxExtent.y) / 2;
        }
        return checkboxBounds;
    }

    abstract int getCheckboxXPosition();

    public boolean getChecked() {
        this.checkWidget();
        boolean checked = false;
        if (this.isCheckable()) {
            checked = this.isChecked;
        }
        return checked;
    }

    public Display getDisplay() {
        SelectableItemWidget parent = this.getSelectableParent();
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getGrayed() {
        this.checkWidget();
        boolean grayed = false;
        if (this.isCheckable()) {
            grayed = this.isGrayed;
        }
        return grayed;
    }

    int getInsertMarkWidth() {
        return 2;
    }

    SelectableItemWidget getSelectableParent() {
        return this.parent;
    }

    Color getSelectionBackgroundColor() {
        Display display = this.getSelectableParent().getDisplay();
        return display.getSystemColor(26);
    }

    abstract Point getSelectionExtent();

    Color getSelectionForegroundColor() {
        Display display = this.getSelectableParent().getDisplay();
        return display.getSystemColor(27);
    }

    abstract int getSelectionX();

    boolean isCheckHit(Point position) {
        boolean isCheckHit = false;
        if (this.isCheckable()) {
            isCheckHit = this.getCheckboxBounds().contains(position);
        }
        return isCheckHit;
    }

    boolean isCheckable() {
        return (this.getSelectableParent().getStyle() & 0x20) != 0;
    }

    boolean isSelected() {
        return this.isSelected;
    }

    void redrawInsertMark(int yPosition) {
        SelectableItemWidget parent = this.getSelectableParent();
        Point selectionExtent = this.getSelectionExtent();
        int redrawHeight = this.getInsertMarkWidth();
        if (selectionExtent != null) {
            parent.redraw(this.getSelectionX(), yPosition, selectionExtent.x, redrawHeight, false);
            parent.redraw(this.getSelectionX(), yPosition + selectionExtent.y - redrawHeight, selectionExtent.x, redrawHeight, false);
        }
    }

    void redrawSelection(int yPosition) {
        SelectableItemWidget parent = this.getSelectableParent();
        Point selectionExtent = this.getSelectionExtent();
        if (selectionExtent != null) {
            parent.redraw(this.getSelectionX(), yPosition, selectionExtent.x, selectionExtent.y, false);
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        SelectableItemWidget parent = this.getSelectableParent();
        Rectangle redrawRectangle = this.getCheckboxBounds();
        if (this.isCheckable() && this.isChecked != checked) {
            this.isChecked = checked;
            parent.redraw(redrawRectangle.x, redrawRectangle.y, redrawRectangle.width, redrawRectangle.height, false);
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        SelectableItemWidget parent = this.getSelectableParent();
        Rectangle redrawRectangle = this.getCheckboxBounds();
        if (this.isCheckable() && this.isGrayed != grayed) {
            this.isGrayed = grayed;
            parent.redraw(redrawRectangle.x, redrawRectangle.y, redrawRectangle.width, redrawRectangle.height, false);
        }
    }

    void setParent(SelectableItemWidget parent) {
        this.parent = parent;
    }

    void setSelected(boolean selected) {
        this.isSelected = selected;
    }
}

