/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.motif.OS;

public final class Converter {
    static final byte[] NULL_BYTE_ARRAY;
    static final byte[] EMPTY_BYTE_ARRAY;
    static final char[] EMPTY_CHAR_ARRAY;
    static String CodePage;
    static byte[] Unicode;
    static final Object LOCK;
    static String LastMBToWCCodePage;
    static String LastWCToMBCodePage;
    static int LastWCToMB;
    static int LastMBToWC;
    static int BufferSize;
    static int BufferTimes2;
    static int BufferTimes4;

    public static String defaultCodePage() {
        return CodePage;
    }

    static byte[] getAsciiBytes(String str) {
        int length = str.length();
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        return buffer;
    }

    static String getAsciiString(byte[] buffer) {
        int length = buffer.length;
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)buffer[i];
            ++i;
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] mbcsToWcs(String codePage, byte[] buffer) {
        if (buffer == null) {
            return EMPTY_CHAR_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] wideCharStr = new char[length];
        int i = 0;
        while (i < length) {
            if ((buffer[i] & 0xFF) > 127) {
                Object object = LOCK;
                synchronized (object) {
                    int ptr2;
                    int ptr1;
                    int cd;
                    String cp;
                    String string = cp = codePage != null ? codePage : CodePage;
                    if (LastMBToWC != 0 && !cp.equals(LastMBToWCCodePage)) {
                        OS.iconv_close(LastMBToWC);
                        LastMBToWC = 0;
                    }
                    if (LastMBToWC == 0) {
                        LastMBToWCCodePage = cp;
                        LastMBToWC = OS.iconv_open(Unicode, Converter.getAsciiBytes(cp));
                        if (LastMBToWC == -1) {
                            LastMBToWC = 0;
                        }
                    }
                    if ((cd = LastMBToWC) == 0) {
                        return EMPTY_CHAR_ARRAY;
                    }
                    int inBytes = length;
                    int outBytes = length * 2;
                    if (length <= BufferSize * 2) {
                        ptr1 = BufferTimes2;
                        ptr2 = BufferTimes4;
                    } else {
                        ptr1 = OS.XtMalloc(inBytes);
                        ptr2 = OS.XtMalloc(outBytes);
                    }
                    int[] inBuf = new int[]{ptr1};
                    int[] inBytesLeft = new int[]{inBytes};
                    int[] outBuf = new int[]{ptr2};
                    int[] outBytesLeft = new int[]{outBytes};
                    OS.memmove(ptr1, buffer, inBytes);
                    OS.iconv(cd, inBuf, inBytesLeft, outBuf, outBytesLeft);
                    outBytes = outBuf[0] - ptr2;
                    wideCharStr = new char[outBytes / 2];
                    OS.memmove(wideCharStr, ptr2, outBytes);
                    if (ptr1 != BufferTimes2) {
                        OS.XtFree(ptr1);
                    }
                    if (ptr2 != BufferTimes4) {
                        OS.XtFree(ptr2);
                    }
                }
                return wideCharStr;
            }
            wideCharStr[i] = (char)buffer[i];
            ++i;
        }
        return wideCharStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        Object object = LOCK;
        synchronized (object) {
            if (BufferTimes2 != 0) {
                OS.XtFree(BufferTimes2);
            }
            if (BufferTimes4 != 0) {
                OS.XtFree(BufferTimes4);
            }
            if (LastWCToMB != 0) {
                OS.iconv_close(LastWCToMB);
            }
            if (LastMBToWC != 0) {
                OS.iconv_close(LastMBToWC);
            }
            BufferTimes2 = 0;
            BufferTimes4 = 0;
            LastWCToMB = 0;
            LastMBToWC = 0;
        }
    }

    public static byte[] wcsToMbcs(String codePage, char[] buffer) {
        return Converter.wcsToMbcs(codePage, buffer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] wcsToMbcs(String codePage, char[] buffer, boolean terminate) {
        if (buffer == null) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        byte[] mbcs = new byte[terminate ? length + 1 : length];
        int i = 0;
        while (i < length) {
            if ((buffer[i] & 0xFFFF) > 127) {
                Object object = LOCK;
                synchronized (object) {
                    int ptr2;
                    int ptr1;
                    int cd;
                    String cp;
                    String string = cp = codePage != null ? codePage : CodePage;
                    if (LastWCToMB != 0 && !cp.equals(LastWCToMBCodePage)) {
                        OS.iconv_close(LastWCToMB);
                        LastWCToMB = 0;
                    }
                    if (LastWCToMB == 0) {
                        LastWCToMBCodePage = cp;
                        LastWCToMB = OS.iconv_open(Converter.getAsciiBytes(cp), Unicode);
                        if (LastWCToMB == -1) {
                            LastWCToMB = 0;
                        }
                    }
                    if ((cd = LastWCToMB) == 0) {
                        return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
                    }
                    int inBytes = length * 2;
                    int outBytes = length * 4;
                    if (length <= BufferSize) {
                        ptr1 = BufferTimes2;
                        ptr2 = BufferTimes4;
                    } else {
                        ptr1 = OS.XtMalloc(inBytes);
                        ptr2 = OS.XtMalloc(outBytes);
                    }
                    int[] inBuf = new int[]{ptr1};
                    int[] inBytesLeft = new int[]{inBytes};
                    int[] outBuf = new int[]{ptr2};
                    int[] outBytesLeft = new int[]{outBytes};
                    OS.memmove(ptr1, buffer, inBytes);
                    while (inBytesLeft[0] > 0) {
                        OS.iconv(cd, inBuf, inBytesLeft, outBuf, outBytesLeft);
                        if (inBytesLeft[0] == 0) continue;
                        inBuf[0] = inBuf[0] + 2;
                        inBytesLeft[0] = inBytesLeft[0] - 2;
                    }
                    outBytes = outBuf[0] - ptr2;
                    mbcs = new byte[terminate ? outBytes + 1 : outBytes];
                    OS.memmove(mbcs, ptr2, outBytes);
                    if (ptr1 != BufferTimes2) {
                        OS.XtFree(ptr1);
                    }
                    if (ptr2 != BufferTimes4) {
                        OS.XtFree(ptr2);
                    }
                }
                return mbcs;
            }
            mbcs[i] = (byte)buffer[i];
            ++i;
        }
        return mbcs;
    }

    public static byte[] wcsToMbcs(String codePage, String string) {
        return Converter.wcsToMbcs(codePage, string, false);
    }

    public static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        if (terminate) {
            if (string == null) {
                return NULL_BYTE_ARRAY;
            }
            int count = string.length();
            char[] buffer = new char[count + 1];
            string.getChars(0, count, buffer, 0);
            return Converter.wcsToMbcs(codePage, buffer, false);
        }
        if (string == null) {
            return EMPTY_BYTE_ARRAY;
        }
        int count = string.length();
        char[] buffer = new char[count];
        string.getChars(0, count, buffer, 0);
        return Converter.wcsToMbcs(codePage, buffer, false);
    }

    static {
        int length;
        NULL_BYTE_ARRAY = new byte[1];
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_CHAR_ARRAY = new char[0];
        LOCK = new Object();
        Unicode = Converter.getAsciiBytes("UCS-2");
        int item = OS.nl_langinfo(OS.CODESET);
        if (item != 0 && (length = OS.strlen(item)) > 0) {
            byte[] buffer = new byte[length];
            OS.memmove(buffer, item, length);
            CodePage = new String(buffer);
            if (OS.IsSunOS && length > 3 && CodePage.indexOf("ISO") == 0) {
                CodePage = CodePage.substring(3, length);
            }
        } else {
            CodePage = OS.IsLinux ? "ISO-8859-1" : (OS.IsAIX ? "ISO8859-1" : (OS.IsSunOS ? "8859-1" : "iso8859_1"));
        }
        BufferSize = 512;
        BufferTimes2 = OS.XtMalloc(BufferSize * 2);
        BufferTimes4 = OS.XtMalloc(BufferSize * 4);
    }
}

