/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String TYPENAME1 = "text/rtf";
    private static final int TYPEID1 = Transfer.registerType("text/rtf");
    private static final String TYPENAME2 = "TEXT/RTF";
    private static final int TYPEID2 = Transfer.registerType("TEXT/RTF");
    private static final String TYPENAME3 = "application/rtf";
    private static final int TYPEID3 = Transfer.registerType("application/rtf");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof String)) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, (String)object, true);
        super.javaToNative(buffer, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] buffer = (byte[])super.nativeToJava(transferData);
        if (buffer == null) {
            return null;
        }
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        String string = new String(unicode);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME1, TYPENAME2, TYPENAME3};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID1, TYPEID2, TYPEID3};
    }
}

