/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.internal.boot.ClassStats;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;
import org.eclipse.core.internal.boot.InternalBootLoader;
import org.eclipse.core.internal.boot.PlatformClassLoader;
import org.eclipse.core.internal.boot.PlatformConfiguration;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.plugins.InternalFactory;
import org.eclipse.core.internal.plugins.PluginClassLoader;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.plugins.RegistryCacheReader;
import org.eclipse.core.internal.plugins.RegistryLoader;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.AuthorizationDatabase;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.PlatformMetaArea;
import org.eclipse.core.internal.runtime.PlatformURLPluginHandlerFactory;
import org.eclipse.core.internal.runtime.PluginStats;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public final class InternalPlatform {
    private static IAdapterManager adapterManager;
    private static JobManager jobManager;
    private static PluginRegistry registry;
    private static Map regIndex;
    private static ArrayList logListeners;
    private static Map logs;
    private static PlatformLogWriter platformLog;
    private static PlatformMetaArea metaArea;
    private static boolean initialized;
    private static Runnable endOfInitializationHandler;
    private static IPath location;
    private static PluginClassLoader xmlClassLoader;
    private static long cacheReadTimeStamp;
    private static boolean debugEnabled;
    private static boolean consoleLogEnabled;
    private static ILogListener consoleLog;
    private static Properties options;
    private static AuthorizationDatabase keyring;
    private static String keyringFile;
    private static String password;
    private static boolean splashDown;
    private static boolean cacheRegistry;
    private static boolean noLazyRegistryCacheLoading;
    private static String pluginCustomizationFile;
    private static File lockFile;
    private static RandomAccessFile lockRAF;
    private static boolean doVersionCheck;
    private static boolean writeVersion;
    private static final String PLUGIN_CUSTOMIZATION_BASE_NAME = "plugin_customization";
    private static final String PLUGIN_CUSTOMIZATION_FILE_NAME = "plugin_customization.ini";
    private static final String PI_XML = "org.apache.xerces";
    private static final String PLUGINSDIR = "plugins/";
    private static final String XML_LOCATION = "plugins/org.apache.xerces/";
    private static final String OPTION_DEBUG = "org.eclipse.core.runtime/debug";
    private static final String OPTION_DEBUG_SYSTEM_CONTEXT = "org.eclipse.core.runtime/debug/context";
    private static final String OPTION_DEBUG_STARTUP = "org.eclipse.core.runtime/timing/startup";
    private static final String OPTION_DEBUG_SHUTDOWN = "org.eclipse.core.runtime/timing/shutdown";
    private static final String OPTION_DEBUG_PLUGINS = "org.eclipse.core.runtime/registry/debug";
    private static final String OPTION_DEBUG_PLUGINS_DUMP = "org.eclipse.core.runtime/registry/debug/dump";
    private static final String OPTION_DEBUG_PREFERENCES = "org.eclipse.core.runtime/preferences/debug";
    private static final String LOG = "-consolelog";
    private static final String KEYRING = "-keyring";
    protected static final String PASSWORD = "-password";
    private static final String NOREGISTRYCACHE = "-noregistrycache";
    private static final String NO_LAZY_REGISTRY_CACHE_LOADING = "-noLazyRegistryCacheLoading";
    private static final String PLUGIN_CUSTOMIZATION = "-plugincustomization";
    private static final String NO_PACKAGE_PREFIXES = "-noPackagePrefixes";
    private static final String NO_VERSION_CHECK = "-noversioncheck";
    public static boolean DEBUG;
    public static boolean DEBUG_CONTEXT;
    public static boolean DEBUG_PLUGINS;
    public static boolean DEBUG_STARTUP;
    public static boolean DEBUG_SHUTDOWN;
    public static String DEBUG_PLUGINS_DUMP;
    public static boolean DEBUG_PREFERENCES;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String METADATA_VERSION_KEY = "org.eclipse.core.runtime";
    private static final int METADATA_VERSION_VALUE = 1;

    static {
        regIndex = null;
        logListeners = new ArrayList(5);
        logs = new HashMap(5);
        platformLog = null;
        endOfInitializationHandler = null;
        xmlClassLoader = null;
        debugEnabled = false;
        consoleLogEnabled = false;
        consoleLog = null;
        options = null;
        keyring = null;
        keyringFile = null;
        password = "";
        splashDown = false;
        cacheRegistry = true;
        noLazyRegistryCacheLoading = false;
        pluginCustomizationFile = null;
        lockFile = null;
        lockRAF = null;
        doVersionCheck = true;
        writeVersion = true;
        DEBUG = false;
        DEBUG_CONTEXT = false;
        DEBUG_PLUGINS = false;
        DEBUG_STARTUP = false;
        DEBUG_SHUTDOWN = false;
        DEBUG_PLUGINS_DUMP = null;
        DEBUG_PREFERENCES = false;
    }

    private InternalPlatform() {
    }

    private static void activateDefaultPlugins() throws CoreException {
        PluginDescriptor descriptor = (PluginDescriptor)registry.getPluginDescriptor(METADATA_VERSION_KEY);
        PlatformClassLoader loader = PlatformClassLoader.getDefault();
        descriptor.activateDefaultPlugins((DelegatingURLClassLoader)loader);
        loader.setPackagePrefixes(PluginClassLoader.initializePrefixes(descriptor, loader.getPrefixId()));
        descriptor.setPluginClassLoader((DelegatingURLClassLoader)loader);
        descriptor.getPlugin();
        descriptor = (PluginDescriptor)registry.getPluginDescriptor(PI_XML, xmlClassLoader.getPluginDescriptor().getVersionIdentifier());
        descriptor.activateDefaultPlugins(xmlClassLoader);
        xmlClassLoader.setPackagePrefixes(PluginClassLoader.initializePrefixes(descriptor, xmlClassLoader.getPrefixId()));
        descriptor.setPluginClassLoader(xmlClassLoader);
        xmlClassLoader.setPluginDescriptor(descriptor);
        descriptor.getPlugin();
    }

    public static void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        keyring.addAuthorizationInfo(serverUrl, realm, authScheme, new HashMap(info));
        keyring.save();
    }

    public static void addLogListener(ILogListener listener) {
        InternalPlatform.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            ((AbstractCollection)logListeners).remove(listener);
            logListeners.add(listener);
        }
    }

    public static void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        keyring.addProtectionSpace(resourceUrl, realm);
        keyring.save();
    }

    public static URL asLocalURL(URL url) throws IOException {
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (!(connection instanceof PlatformURLConnection)) {
            return url;
        }
        String file = connection.getURL().getFile();
        if (file.endsWith("/") && !file.endsWith("!/")) {
            throw new IOException();
        }
        return ((PlatformURLConnection)connection).getURLAsLocal();
    }

    private static void assertInitialized() {
        if (!initialized) {
            Assert.isTrue(false, Policy.bind("meta.appNotInit"));
        }
    }

    private static synchronized void clearLockFile() {
        try {
            if (lockRAF != null) {
                lockRAF.close();
                lockRAF = null;
            }
        }
        catch (IOException iOException) {}
        if (lockFile != null) {
            lockFile.delete();
            lockFile = null;
        }
    }

    private static synchronized void createLockFile() throws CoreException {
        String lockLocation = metaArea.getLocation().append(".lock").toOSString();
        lockFile = new File(lockLocation);
        if (lockFile.exists()) {
            lockFile.delete();
        }
        if (lockFile.exists()) {
            String message = Policy.bind("meta.inUse", lockLocation);
            throw new CoreException(new Status(4, METADATA_VERSION_KEY, 5, message, null));
        }
        try {
            lockRAF = new RandomAccessFile(lockFile, "rw");
            lockRAF.writeByte(0);
        }
        catch (IOException e) {
            String message = Policy.bind("meta.failCreateLock", lockLocation);
            throw new CoreException(new Status(4, METADATA_VERSION_KEY, 5, message, e));
        }
    }

    private static void createXMLClassLoader() {
        InternalFactory factory = new InternalFactory(null);
        PluginDescriptor descriptor = (PluginDescriptor)((Factory)factory).createPluginDescriptor();
        descriptor.setEnabled(true);
        descriptor.setId(PI_XML);
        PlatformConfiguration config = InternalBootLoader.getCurrentPlatformConfiguration();
        PlatformConfiguration.BootDescriptor bd = config.getPluginBootDescriptor(PI_XML);
        descriptor.setVersion(bd.getVersion());
        try {
            URL url = bd.getPluginDirectoryURL();
            if (url == null) {
                url = new URL(BootLoader.getInstallURL(), XML_LOCATION);
            }
            descriptor.setLocation(url.toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ArrayList<LibraryModel> libList = new ArrayList<LibraryModel>();
        String[] libs = bd.getLibraries();
        int i = 0;
        while (i < libs.length) {
            LibraryModel lib = ((Factory)factory).createLibrary();
            lib.setName(libs[i]);
            lib.setExports(new String[]{"*"});
            libList.add(lib);
            ++i;
        }
        descriptor.setRuntime(libList.toArray(new LibraryModel[0]));
        xmlClassLoader = (PluginClassLoader)((Object)descriptor.getPluginClassLoader(false));
    }

    public static void endSplash() {
        String startString;
        if (DEBUG && (startString = Platform.getDebugOption("org.eclipse.core.runtime/starttime")) != null) {
            try {
                long start = Long.parseLong(startString);
                long end = System.currentTimeMillis();
                System.out.println("Startup complete: " + (end - start) + "ms");
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (splashDown) {
            return;
        }
        splashDown = true;
        if (DelegatingURLClassLoader.MONITOR_PLUGINS) {
            PluginStats.setBooting(false);
        }
        if (DelegatingURLClassLoader.MONITOR_CLASSES) {
            ClassStats.setBooting((boolean)false);
        }
        InternalPlatform.run(endOfInitializationHandler);
    }

    public static void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        keyring.flushAuthorizationInfo(serverUrl, realm, authScheme);
        keyring.save();
    }

    public static IAdapterManager getAdapterManager() {
        InternalPlatform.assertInitialized();
        return adapterManager;
    }

    private static URL[] getAugmentedPluginPath(URL[] pluginPath) {
        IPath result = metaArea.getLocation().append(".plugins").append("org.eclipse.scripting").append("plugin.xml");
        String userScriptName = result.toString();
        URL userScriptUrl = null;
        try {
            userScriptUrl = new URL("file", null, 0, userScriptName);
        }
        catch (MalformedURLException malformedURLException) {
            return pluginPath;
        }
        URL[] newPath = new URL[pluginPath.length + 1];
        System.arraycopy(pluginPath, 0, newPath, 0, pluginPath.length);
        newPath[newPath.length - 1] = userScriptUrl;
        return newPath;
    }

    public static Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Map info = keyring.getAuthorizationInfo(serverUrl, realm, authScheme);
        return info == null ? null : new HashMap(info);
    }

    public static boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = InternalPlatform.getDebugOption(option);
        return optionValue != null && optionValue.equalsIgnoreCase("true") || defaultValue;
    }

    public static String getDebugOption(String option) {
        return debugEnabled ? options.getProperty(option) : null;
    }

    public static int getIntegerOption(String option, int defaultValue) {
        String value = InternalPlatform.getDebugOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static IJobManager getJobManager() {
        return jobManager;
    }

    public static IPath getLocation() {
        InternalPlatform.assertInitialized();
        return location;
    }

    public static ILog getLog(Plugin plugin) {
        ILog result = (ILog)logs.get(plugin);
        if (result != null) {
            return result;
        }
        result = new Log(plugin);
        logs.put(plugin, result);
        return result;
    }

    public static PlatformMetaArea getMetaArea() {
        return metaArea;
    }

    public static Plugin getPlugin(String id) {
        InternalPlatform.assertInitialized();
        IPluginDescriptor descriptor = InternalPlatform.getPluginRegistry().getPluginDescriptor(id);
        if (descriptor == null) {
            return null;
        }
        try {
            return descriptor.getPlugin();
        }
        catch (CoreException e) {
            InternalPlatform.log(e.getStatus());
            return null;
        }
    }

    public static IPluginRegistry getPluginRegistry() {
        InternalPlatform.assertInitialized();
        return registry;
    }

    public static IPath getPluginStateLocation(IPluginDescriptor descriptor, boolean create) {
        InternalPlatform.assertInitialized();
        IPath result = metaArea.getPluginStateLocation(descriptor);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public static String getProtectionSpace(URL resourceUrl) {
        return keyring.getProtectionSpace(resourceUrl);
    }

    public static Plugin getRuntimePlugin() {
        try {
            return InternalPlatform.getPluginRegistry().getPluginDescriptor(METADATA_VERSION_KEY).getPlugin();
        }
        catch (CoreException e) {
            InternalPlatform.log(e.getStatus());
            return null;
        }
    }

    private static void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Status status;
            Plugin plugin = InternalPlatform.getRuntimePlugin();
            try {
                plugin = ((PluginClassLoader)((Object)code.getClass().getClassLoader())).getPluginDescriptor().getPlugin();
            }
            catch (ClassCastException classCastException) {
            }
            catch (CoreException coreException) {}
            String pluginId = plugin.getDescriptor().getUniqueIdentifier();
            String message = Policy.bind("meta.pluginProblems", pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e);
            }
            plugin.getLog().log(status);
        }
        code.handleException(e);
    }

    public static boolean loaderCheckVersion() {
        boolean proceed;
        writeVersion = proceed = !doVersionCheck || InternalPlatform.checkVersionPrompt();
        if (!proceed) {
            InternalPlatform.endSplash();
        }
        return proceed;
    }

    private static boolean checkVersionPrompt() {
        if (InternalPlatform.checkVersionNoPrompt()) {
            return true;
        }
        String appId = "org.eclipse.ui.versioncheck.prompt";
        IPlatformRunnable runnable = InternalPlatform.loaderGetRunnable(appId);
        if (runnable == null) {
            return true;
        }
        try {
            Object result = runnable.run(null);
            return Boolean.TRUE.equals(result);
        }
        catch (Exception exception) {
            InternalPlatform.log(new Status(4, METADATA_VERSION_KEY, 1, Policy.bind("meta.versionCheckRun", appId), null));
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkVersionNoPrompt() {
        File pluginsDir = metaArea.getLocation().append(".plugins").toFile();
        if (!pluginsDir.exists()) {
            return true;
        }
        int version = -1;
        File versionFile = metaArea.getVersionPath().toFile();
        if (!versionFile.exists()) return version == 1;
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                is.close();
                throw throwable;
            }
            {
                Object var5_8 = null;
            }
            is.close();
            String prop = props.getProperty(METADATA_VERSION_KEY);
            if (prop == null) return version == 1;
            version = Integer.parseInt(prop);
            return version == 1;
        }
        catch (Exception e) {
            InternalPlatform.log(new Status(4, METADATA_VERSION_KEY, 1, Policy.bind("meta.checkVersion", versionFile.toString()), e));
        }
        return version == 1;
    }

    public static IPlatformRunnable loaderGetRunnable(String applicationName) {
        InternalPlatform.assertInitialized();
        IExtension extension = registry.getExtension(METADATA_VERSION_KEY, "applications", applicationName);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IPlatformRunnable)config.createExecutableExtension("run");
        }
        catch (CoreException e) {
            InternalPlatform.getRuntimePlugin().getLog().log(e.getStatus());
            return null;
        }
    }

    public static IPlatformRunnable loaderGetRunnable(String pluginId, String className, Object args) {
        InternalPlatform.assertInitialized();
        PluginDescriptor descriptor = (PluginDescriptor)registry.getPluginDescriptor(pluginId);
        if (descriptor == null) {
            return null;
        }
        try {
            return (IPlatformRunnable)descriptor.createExecutableExtension(className, args, null, null);
        }
        catch (CoreException e) {
            InternalPlatform.getRuntimePlugin().getLog().log(e.getStatus());
            return null;
        }
    }

    public static void loaderShutdown() {
        InternalPlatform.assertInitialized();
        if (writeVersion) {
            InternalPlatform.writeVersion();
        }
        registry.shutdown(null);
        JobManager.shutdown();
        InternalPlatform.clearLockFile();
        if (DEBUG_PLUGINS && DEBUG_PLUGINS_DUMP != null) {
            registry.debugRegistry(DEBUG_PLUGINS_DUMP);
        }
        if (cacheRegistry) {
            try {
                registry.saveRegistry();
            }
            catch (IOException e) {
                String message = Policy.bind("meta.unableToWriteRegistry");
                Status status = new Status(4, METADATA_VERSION_KEY, 2, message, e);
                InternalPlatform.getRuntimePlugin().getLog().log(status);
                if (DEBUG) {
                    System.out.println(status.getMessage());
                }
            }
        } else {
            registry.flushRegistry();
        }
        if (platformLog != null) {
            platformLog.shutdown();
        }
        initialized = false;
    }

    public static void loaderStartup(URL[] pluginPath, String locationString, Properties bootOptions, String[] args, Runnable handler) throws CoreException {
        endOfInitializationHandler = handler;
        InternalPlatform.processCommandLine(args);
        InternalPlatform.setupMetaArea(locationString);
        InternalPlatform.createLockFile();
        adapterManager = new AdapterManager();
        InternalPlatform.loadOptions(bootOptions);
        jobManager = JobManager.getInstance();
        InternalPlatform.createXMLClassLoader();
        MultiStatus problems = InternalPlatform.loadRegistry(pluginPath);
        initialized = true;
        PlatformURLPluginHandlerFactory.startup();
        InternalPlatform.activateDefaultPlugins();
        if (DEBUG_CONTEXT) {
            System.out.println("OS: " + BootLoader.getOS() + " WS: " + BootLoader.getWS() + " NL: " + BootLoader.getNL() + " ARCH: " + BootLoader.getOSArch());
        }
        platformLog = new PlatformLogWriter(metaArea.getLogLocation().toFile());
        InternalPlatform.addLogListener(platformLog);
        if (consoleLogEnabled) {
            consoleLog = new PlatformLogWriter(System.out);
            InternalPlatform.addLogListener(consoleLog);
        }
        if (!problems.isOK()) {
            InternalPlatform.getRuntimePlugin().getLog().log(problems);
        }
        InternalPlatform.loadKeyring();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeVersion() {
        File versionFile = metaArea.getVersionPath().toFile();
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(versionFile));
            try {
                String versionLine = "org.eclipse.core.runtime=1";
                ((OutputStream)output).write(versionLine.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ((OutputStream)output).close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                ((OutputStream)output).close();
                return;
            }
        }
        catch (Exception e) {
            InternalPlatform.log(new Status(4, METADATA_VERSION_KEY, 1, Policy.bind("meta.writeVersion", versionFile.toString()), e));
        }
    }

    private static void loadKeyring() {
        if (keyringFile != null) {
            try {
                keyring = new AuthorizationDatabase(keyringFile, password);
            }
            catch (CoreException e) {
                InternalPlatform.log(e.getStatus());
            }
            if (keyring == null) {
                new File(keyringFile).delete();
                try {
                    keyring = new AuthorizationDatabase(keyringFile, password);
                }
                catch (CoreException coreException) {}
            }
        }
        if (keyring == null) {
            keyring = new AuthorizationDatabase();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadOptions(Properties bootOptions) {
        if (bootOptions == null) {
            debugEnabled = false;
            return;
        }
        debugEnabled = true;
        options = new Properties(bootOptions);
        try {
            FileInputStream input = new FileInputStream(InternalPlatform.getMetaArea().getOptionsLocation().toFile());
            try {
                options.load(input);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            {
                Object var2_4 = null;
                ((InputStream)input).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        Iterator i = ((Hashtable)options).keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                DEBUG = InternalPlatform.getBooleanOption(OPTION_DEBUG, false);
                if (DEBUG) {
                    DEBUG_CONTEXT = InternalPlatform.getBooleanOption(OPTION_DEBUG_SYSTEM_CONTEXT, false);
                    DEBUG_STARTUP = InternalPlatform.getBooleanOption(OPTION_DEBUG_STARTUP, false);
                    DEBUG_SHUTDOWN = InternalPlatform.getBooleanOption(OPTION_DEBUG_SHUTDOWN, false);
                    DEBUG_PLUGINS = InternalPlatform.getBooleanOption(OPTION_DEBUG_PLUGINS, false);
                    DEBUG_PLUGINS_DUMP = InternalPlatform.getDebugOption(OPTION_DEBUG_PLUGINS_DUMP);
                    DEBUG_PREFERENCES = InternalPlatform.getBooleanOption(OPTION_DEBUG_PREFERENCES, false);
                }
                InternalBootLoader.setupOptions();
                return;
            }
            Object key = i.next();
            ((Hashtable)options).put(key, ((String)((Hashtable)options).get(key)).trim());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MultiStatus loadRegistry(URL[] pluginPath) {
        MultiStatus problems = new MultiStatus(METADATA_VERSION_KEY, 1, Policy.bind("parse.registryProblems"), null);
        InternalFactory factory = new InternalFactory(problems);
        IPath path = InternalPlatform.getMetaArea().getRegistryPath();
        File cacheFile = path.toFile();
        DataInputStream input = null;
        registry = null;
        URL[] augmentedPluginPath = InternalPlatform.getAugmentedPluginPath(pluginPath);
        if (cacheFile.exists() && cacheRegistry) {
            try {
                input = new DataInputStream(new BufferedInputStream(new FileInputStream(path.toFile())));
                try {
                    long start = System.currentTimeMillis();
                    if (DEBUG && !noLazyRegistryCacheLoading) {
                        System.out.println("Lazily loading plug-in registry cache");
                    }
                    RegistryCacheReader cacheReader = new RegistryCacheReader(factory, !noLazyRegistryCacheLoading);
                    registry = (PluginRegistry)cacheReader.readPluginRegistry(input, augmentedPluginPath, DEBUG && DEBUG_PLUGINS);
                    if (!noLazyRegistryCacheLoading) {
                        cacheReader.setLazilyLoadExtensions(false);
                    }
                    if (DEBUG) {
                        System.out.println("Read registry cache: " + (System.currentTimeMillis() - start) + "ms");
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    input.close();
                    throw throwable;
                }
                {
                    Object var10_14 = null;
                    input.close();
                }
            }
            catch (IOException ioe) {
                Status status = new Status(4, METADATA_VERSION_KEY, 2, Policy.bind("meta.unableToReadCache"), ioe);
                problems.merge(status);
            }
        }
        if (registry == null) {
            InternalPlatform.clearRegIndex();
            if (cacheFile.exists() && !cacheFile.delete()) {
                Status status = new Status(2, METADATA_VERSION_KEY, 6, Policy.bind("meta.unableToDeleteCache", cacheFile.getAbsolutePath()), null);
                problems.merge(status);
            }
            long start = System.currentTimeMillis();
            InternalPlatform.setRegistryCacheTimeStamp(BootLoader.getCurrentPlatformConfiguration().getPluginsChangeStamp());
            registry = (PluginRegistry)InternalPlatform.parsePlugins(augmentedPluginPath, factory, DEBUG && DEBUG_PLUGINS);
            IStatus resolveStatus = registry.resolve(true, true);
            problems.merge(resolveStatus);
            registry.markReadOnly();
            if (DEBUG) {
                System.out.println("Parse and resolve registry: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        registry.startup(null);
        return problems;
    }

    public static void log(IStatus status) {
        ILogListener[] listeners;
        InternalPlatform.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            listeners = logListeners.toArray(new ILogListener[logListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            ILogListener listener = listeners[i];
            try {
                listener.logging(status, METADATA_VERSION_KEY);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            catch (LinkageError e) {
                e.printStackTrace(System.err);
            }
            ++i;
        }
    }

    public static PluginRegistryModel parsePlugins(URL[] pluginPath, Factory factory) {
        return InternalPlatform.parsePlugins(pluginPath, factory, false);
    }

    public static synchronized PluginRegistryModel parsePlugins(URL[] pluginPath, Factory factory, boolean debug) {
        PluginRegistryModel pluginRegistryModel;
        if (!InternalBootLoader.isRunning() && !InternalBootLoader.isStarting()) {
            return RegistryLoader.parseRegistry(pluginPath, factory, debug);
        }
        PlatformClassLoader.getDefault().setImports(new DelegatingURLClassLoader[]{xmlClassLoader});
        try {
            pluginRegistryModel = RegistryLoader.parseRegistry(pluginPath, factory, debug);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            PlatformClassLoader.getDefault().setImports(null);
            throw throwable;
        }
        PlatformClassLoader.getDefault().setImports(null);
        return pluginRegistryModel;
    }

    private static String[] processCommandLine(String[] args) {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(LOG)) {
                consoleLogEnabled = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NOREGISTRYCACHE)) {
                cacheRegistry = false;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_LAZY_REGISTRY_CACHE_LOADING)) {
                noLazyRegistryCacheLoading = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_PACKAGE_PREFIXES)) {
                PluginClassLoader.usePackagePrefixes = false;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_VERSION_CHECK)) {
                doVersionCheck = false;
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PASSWORD)) {
                    password = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PLUGIN_CUSTOMIZATION)) {
                    pluginCustomizationFile = arg;
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    public static void removeLogListener(ILogListener listener) {
        InternalPlatform.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            ((AbstractCollection)logListeners).remove(listener);
        }
    }

    public static URL resolve(URL url) throws IOException {
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof PlatformURLConnection) {
            return ((PlatformURLConnection)connection).getResolvedURL();
        }
        return url;
    }

    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e) {
            InternalPlatform.handleException(code, e);
        }
        catch (LinkageError e) {
            InternalPlatform.handleException(code, e);
        }
    }

    private static void run(Runnable handler) {
        if (handler == null) {
            return;
        }
        final Runnable finalHandler = handler;
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                finalHandler.run();
            }

            public void handleException(Throwable e) {
            }
        };
        Platform.run(code);
    }

    public static void setDebugOption(String option, String value) {
        if (debugEnabled) {
            options.setProperty(option, value);
        }
    }

    public static void setPluginRegistry(IPluginRegistry value) {
        registry = (PluginRegistry)value;
    }

    private static void setupMetaArea(String locationString) throws CoreException {
        location = new Path(locationString);
        if (!location.isAbsolute()) {
            location = new Path(System.getProperty("user.dir")).append(location);
        }
        if (location.toFile().exists() && !location.toFile().isDirectory()) {
            String message = Policy.bind("meta.notDir", location.toString());
            throw new CoreException(new Status(4, METADATA_VERSION_KEY, 5, message, null));
        }
        metaArea = new PlatformMetaArea(location);
        metaArea.createLocation();
        if (keyringFile == null) {
            keyringFile = metaArea.getLocation().append(".keyring").toOSString();
        }
    }

    public static void addLastModifiedTime(String pathKey, long lastModTime) {
        if (regIndex == null) {
            regIndex = new HashMap(30);
        }
        regIndex.put(pathKey, new Long(lastModTime));
    }

    public static Map getRegIndex() {
        return regIndex;
    }

    public static void clearRegIndex() {
        regIndex = null;
    }

    /*
     * Exception decompiling
     */
    public static Properties getPreferenceTranslator(IPluginDescriptor pluginDescriptor, String basePrefFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 105->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value : value.substring(0, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key.substring(1), dflt);
        }
        return value;
    }

    public static void applyPrimaryFeaturePluginDefaultOverrides(String id, Preferences preferences) {
        IPlatformConfiguration cfg = BootLoader.getCurrentPlatformConfiguration();
        if (cfg == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences unable to find a platform configuration");
            }
            return;
        }
        String primaryFeatureID = cfg.getPrimaryFeatureIdentifier();
        if (primaryFeatureID == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences unable to find a primary feature id");
            }
            return;
        }
        IPlatformConfiguration.IFeatureEntry primaryFeatureEntry = cfg.findConfiguredFeatureEntry(primaryFeatureID);
        if (primaryFeatureEntry == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences unable to find a primary feature entry");
            }
            return;
        }
        String primaryFeaturePluginId = primaryFeatureEntry.getFeaturePluginIdentifier();
        if (primaryFeaturePluginId == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences unable to find a primary feature plugin id");
            }
            return;
        }
        IPluginDescriptor primaryFeatureDescriptor = InternalPlatform.getPluginRegistry().getPluginDescriptor(primaryFeaturePluginId);
        if (primaryFeatureDescriptor == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences unable to find a primary feature");
            }
            return;
        }
        URL pluginCustomizationURL = primaryFeatureDescriptor.find(new Path(PLUGIN_CUSTOMIZATION_FILE_NAME));
        if (pluginCustomizationURL == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Preferences file plugin_customization.ini not found.");
            }
            return;
        }
        if (DEBUG_PREFERENCES) {
            System.out.println("Loading preferences from " + pluginCustomizationURL);
        }
        Properties props = InternalPlatform.getPreferenceTranslator(primaryFeatureDescriptor, PLUGIN_CUSTOMIZATION_BASE_NAME);
        InternalPlatform.applyPluginDefaultOverrides(pluginCustomizationURL, id, preferences, props);
    }

    public static void applyCommandLinePluginDefaultOverrides(String id, Preferences preferences) {
        if (pluginCustomizationFile == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Command line argument -pluginCustomization not used.");
            }
            return;
        }
        try {
            URL pluginCustomizationURL = new File(pluginCustomizationFile).toURL();
            if (DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + pluginCustomizationURL);
            }
            InternalPlatform.applyPluginDefaultOverrides(pluginCustomizationURL, id, preferences, null);
        }
        catch (MalformedURLException e) {
            if (DEBUG_PREFERENCES) {
                System.out.println("MalformedURLException creating URL for plugin customization file " + pluginCustomizationFile);
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void applyPluginDefaultOverrides(URL propertiesURL, String id, Preferences preferences, Properties props) {
        block24: {
            block23: {
                block22: {
                    block21: {
                        overrides = new Properties();
                        in = null;
                        try {
                            try {
                                inFile = new File(propertiesURL.getFile());
                                if (!inFile.exists()) {
                                    if (InternalPlatform.DEBUG_PREFERENCES) {
                                        System.out.println("Preference file " + propertiesURL + " not found.");
                                    }
                                    var7_8 = null;
                                    break block21;
                                }
                                in = new SafeFileInputStream(inFile);
                                if (in == null) {
                                    if (InternalPlatform.DEBUG_PREFERENCES) {
                                        System.out.println("Failed to open " + propertiesURL);
                                    }
                                    break block22;
                                }
                                overrides.load(in);
                                break block23;
                            }
                            catch (IOException e) {
                                if (InternalPlatform.DEBUG_PREFERENCES) {
                                    System.out.println("IOException reading preference file " + propertiesURL);
                                    e.printStackTrace();
                                }
                                var7_10 = null;
                                try {
                                    if (in == null) return;
                                    in.close();
                                    return;
                                }
                                catch (IOException e) {
                                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                                    System.out.println("IOException closing preference file " + propertiesURL);
                                    e.printStackTrace();
                                }
                                return;
                            }
                        }
                        catch (Throwable var8_20) {
                            var7_11 = null;
                            ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl39:
                            // 1 sources

                            if (in == null) throw var8_20;
                            in.close();
                            throw var8_20;
lbl42:
                            // 1 sources

                            catch (IOException e) {
                                if (InternalPlatform.DEBUG_PREFERENCES == false) throw var8_20;
                                System.out.println("IOException closing preference file " + propertiesURL);
                                e.printStackTrace();
                            }
                            throw var8_20;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl49:
                    // 1 sources

                    if (in == null) return;
                    in.close();
                    return;
lbl52:
                    // 1 sources

                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        System.out.println("IOException closing preference file " + propertiesURL);
                        e.printStackTrace();
                    }
                    return;
                }
                var7_9 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl60:
                // 1 sources

                if (in == null) return;
                in.close();
                return;
lbl63:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                    System.out.println("IOException closing preference file " + propertiesURL);
                    e.printStackTrace();
                }
                return;
            }
            var7_12 = null;
            ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl71:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block24;
lbl74:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block24;
                System.out.println("IOException closing preference file " + propertiesURL);
                e.printStackTrace();
            }
        }
        it = overrides.entrySet().iterator();
        while (true) {
            if (!it.hasNext()) break;
            entry = it.next();
            qualifiedKey = (String)entry.getKey();
            s = qualifiedKey.indexOf(47);
            if (s < 0 || s == 0 || s == qualifiedKey.length() - 1 || !(pluginId = qualifiedKey.substring(0, s)).equals(id)) continue;
            propertyName = qualifiedKey.substring(s + 1);
            value = (String)entry.getValue();
            value = InternalPlatform.translatePreference(value, props);
            preferences.setDefault(propertyName, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        System.out.println("Preferences now set as follows:");
        prefNames = preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = preferences.getString(prefNames[i]);
            System.out.println("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = preferences.getDefaultString(prefNames[i]);
            System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    public static long getRegistryCacheTimeStamp() {
        return cacheReadTimeStamp;
    }

    public static void setRegistryCacheTimeStamp(long timeStamp) {
        cacheReadTimeStamp = timeStamp;
    }
}

