/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.jobs.LockListener;

public class LockManager {
    private LockListener lockListener;
    private final ArrayList locks = new ArrayList();
    private final Map lockThreads = new HashMap(20);

    public void aboutToRelease() {
        if (this.lockListener != null) {
            this.lockListener.aboutToRelease();
        }
    }

    public boolean aboutToWait(Thread lockOwner) {
        if (this.lockListener != null) {
            return this.lockListener.aboutToWait(lockOwner);
        }
        return false;
    }

    synchronized void addLockThread(Thread thread) {
        int[] value = (int[])this.lockThreads.get(thread);
        if (value == null) {
            value = new int[1];
            this.lockThreads.put(thread, value);
        }
        value[0] = value[0] + 1;
    }

    public synchronized OrderedLock newLock() {
        OrderedLock result = new OrderedLock(this);
        this.locks.add(result);
        return result;
    }

    synchronized void removeLockThread(Thread thread) {
        int[] value = (int[])this.lockThreads.get(thread);
        if (value == null) {
            Assert.isNotNull(value, "Removing lock thread that didn't own a lock");
        }
        if ((value[0] = value[0] - 1) <= 0) {
            this.lockThreads.remove(thread);
        }
    }

    public void setLockListener(LockListener listener) {
        this.lockListener = listener;
    }

    public synchronized LockState[] suspendGreaterLocks(OrderedLock toLock) {
        Thread currentThread = Thread.currentThread();
        int lockCount = this.locks.size();
        int i = this.locks.indexOf(toLock);
        if (i == -1) {
            Assert.isTrue(false, "OrderedLock not found: " + toLock);
            return null;
        }
        ++i;
        ArrayList<LockState> toAcquire = null;
        while (i < lockCount) {
            OrderedLock lock = (OrderedLock)this.locks.get(i);
            if (lock.getCurrentOperationThread() == currentThread) {
                if (toAcquire == null) {
                    toAcquire = new ArrayList<LockState>();
                }
                toAcquire.add(LockState.suspend(lock));
            }
            ++i;
        }
        if (toAcquire == null) {
            return null;
        }
        return toAcquire.toArray(new LockState[toAcquire.size()]);
    }

    public synchronized boolean isLockOwner() {
        return this.lockThreads.containsKey(Thread.currentThread());
    }

    synchronized void removeAllLocks(Thread thread) {
        this.lockThreads.remove(thread);
    }

    public static class LockState {
        private int depth;
        private OrderedLock lock;

        protected static LockState suspend(OrderedLock lock) {
            LockState state = new LockState();
            state.lock = lock;
            state.depth = lock.doRelease();
            return state;
        }

        protected void resume() {
            while (true) {
                try {
                    if (!this.lock.doAcquire(this.lock.createSemaphore(), Long.MAX_VALUE)) continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.lock.setDepth(this.depth);
        }
    }
}

