/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.FeatureProcessor;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PartOfSpeech;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.en.us.USEnglish;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class FeatureProcessors {
    private static final PathExtractor FIRST_SYLLABLE_PATH = new PathExtractorImpl("R:SylStructure.parent.R:Phrase.parent.daughter.R:SylStructure.daughter", false);
    private static final PathExtractor LAST_SYLLABLE_PATH = new PathExtractorImpl("R:SylStructure.parent.R:Phrase.parent.daughtern.R:SylStructure.daughter", false);
    private static final PathExtractor LAST_LAST_SYLLABLE_PATH = new PathExtractorImpl("R:SylStructure.parent.R:Phrase.parent.daughtern.R:SylStructure.daughtern", false);
    private static final PathExtractor SUB_PHRASE_PATH = new PathExtractorImpl("R:SylStructure.parent.R:Phrase.parent.p", false);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile(USEnglish.RX_DOUBLE);
    private static final Pattern DIGITS_PATTERN = Pattern.compile(USEnglish.RX_DIGITS);
    private static Set months = new HashSet();
    private static Set days;

    private FeatureProcessors() {
    }

    public static String getPhoneFeature(Item item, String string) {
        Voice voice = item.getUtterance().getVoice();
        String string2 = voice.getPhoneFeature(item.toString(), string);
        return string2;
    }

    public static String wordBreak(Item item) throws ProcessException {
        Item item2 = item.getItemAs("Phrase");
        if (item2 == null || item2.getNext() != null) {
            return "1";
        }
        String string = item2.getParent().toString();
        if (string.equals("BB")) {
            return "4";
        }
        if (string.equals("B")) {
            return "3";
        }
        return "1";
    }

    public static String wordPunc(Item item) throws ProcessException {
        Item item2 = item.getItemAs("Token");
        if (item2 != null && item2.getNext() != null) {
            return "";
        }
        if (item2 != null && item2.getParent() != null) {
            return item2.getParent().getFeatures().getString("punc");
        }
        return "";
    }

    private static String segCodaCtype(Item item, String string) {
        Item item2 = item.getItemAs("SylStructure").getParent().getLastDaughter();
        while (item2 != null) {
            if ("+".equals(FeatureProcessors.getPhoneFeature(item2, "vc"))) {
                return "0";
            }
            if (string.equals(FeatureProcessors.getPhoneFeature(item2, "ctype"))) {
                return "1";
            }
            item2 = item2.getPrevious();
        }
        return "0";
    }

    private static String segOnsetCtype(Item item, String string) {
        Item item2 = item.getItemAs("SylStructure").getParent().getDaughter();
        while (item2 != null) {
            if ("+".equals(FeatureProcessors.getPhoneFeature(item2, "vc"))) {
                return "0";
            }
            if (string.equals(FeatureProcessors.getPhoneFeature(item2, "ctype"))) {
                return "1";
            }
            item2 = item2.getNext();
        }
        return "0";
    }

    private static boolean isAccented(Item item) {
        return item.getFeatures().isPresent("accent") || item.getFeatures().isPresent("endtone");
    }

    private static int rail(int n) {
        return n > 19 ? 19 : n;
    }

    static {
        months.add("jan");
        months.add("january");
        months.add("feb");
        months.add("february");
        months.add("mar");
        months.add("march");
        months.add("apr");
        months.add("april");
        months.add("may");
        months.add("jun");
        months.add("june");
        months.add("jul");
        months.add("july");
        months.add("aug");
        months.add("august");
        months.add("sep");
        months.add("september");
        months.add("oct");
        months.add("october");
        months.add("nov");
        months.add("november");
        months.add("dec");
        months.add("december");
        days = new HashSet();
        days.add("sun");
        days.add("sunday");
        days.add("mon");
        days.add("monday");
        days.add("tue");
        days.add("tuesday");
        days.add("wed");
        days.add("wednesday");
        days.add("thu");
        days.add("thursday");
        days.add("fri");
        days.add("friday");
        days.add("sat");
        days.add("saturday");
    }

    public static class SegmentDuration
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            if (item == null) {
                return "0";
            }
            if (item.getPrevious() == null) {
                return item.getFeatures().getObject("end").toString();
            }
            return Float.toString(item.getFeatures().getFloat("end") - item.getPrevious().getFeatures().getFloat("end"));
        }
    }

    public static class SubPhrases
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            Item item2;
            int n = 0;
            Item item3 = item2 = SUB_PHRASE_PATH.findItem(item);
            while (item3 != null) {
                ++n;
                item3 = item3.getPrevious();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class SegOnsetCoda
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            Item item2 = item.getItemAs("SylStructure").getNext();
            while (item2 != null) {
                if ("+".equals(FeatureProcessors.getPhoneFeature(item2, "vc"))) {
                    return "onset";
                }
                item2 = item2.getNext();
            }
            return "coda";
        }
    }

    public static class SegOnsetGlide
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            if (FeatureProcessors.segOnsetCtype(item, "r").equals("0")) {
                return FeatureProcessors.segOnsetCtype(item, "l");
            }
            return "1";
        }
    }

    public static class SegCodaGlide
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            if (FeatureProcessors.segCodaCtype(item, "r").equals("0")) {
                return FeatureProcessors.segCodaCtype(item, "l");
            }
            return "1";
        }
    }

    public static class SegOnsetNasal
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.segOnsetCtype(item, "n");
        }
    }

    public static class SegCodaNasal
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.segCodaCtype(item, "n");
        }
    }

    public static class SegOnsetStop
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.segOnsetCtype(item, "s");
        }
    }

    public static class SegCodaStop
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.segCodaCtype(item, "s");
        }
    }

    public static class SegOnsetFric
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.segOnsetCtype(item, "f");
        }
    }

    public static class SegCodaFric
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.segCodaCtype(item, "f");
        }
    }

    public static class SylCodaSize
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("SylStructure").getLastDaughter();
            while (item2 != null) {
                if ("+".equals(FeatureProcessors.getPhoneFeature(item2, "vc"))) break;
                item2 = item2.getPrevious();
                ++n;
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class SylOnsetSize
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("SylStructure").getDaughter();
            while (item2 != null) {
                if ("+".equals(FeatureProcessors.getPhoneFeature(item2, "vc"))) break;
                ++n;
                item2 = item2.getNext();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class PH_VRnd
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "vrnd");
        }
    }

    public static class PH_VLength
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "vlng");
        }
    }

    public static class PH_VHeight
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "vheight");
        }
    }

    public static class PH_VFront
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "vfront");
        }
    }

    public static class PH_VC
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "vc");
        }
    }

    public static class PH_CVox
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "cvox");
        }
    }

    public static class PH_CType
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "ctype");
        }
    }

    public static class PH_CPlace
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.getPhoneFeature(item, "cplace");
        }
    }

    public static class WordPunc
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.wordPunc(item);
        }
    }

    public static class WordBreak
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            return FeatureProcessors.wordPunc(item);
        }
    }

    public static class SylBreak
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            Item item2 = item.getItemAs("SylStructure");
            if (item2 == null) {
                return "1";
            }
            if (item2.getNext() != null) {
                return "0";
            }
            if (item2.getParent() == null) {
                return "1";
            }
            return FeatureProcessors.wordBreak(item2.getParent());
        }
    }

    public static class SylOut
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("Syllable");
            Item item3 = LAST_LAST_SYLLABLE_PATH.findItem(item);
            Item item4 = item2;
            while (item4 != null) {
                if (item4.equalsShared(item3)) break;
                ++n;
                item4 = item4.getNext();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class SylIn
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("Syllable");
            Item item3 = FIRST_SYLLABLE_PATH.findItem(item);
            Item item4 = item2;
            while (item4 != null) {
                if (item4.equalsShared(item3)) break;
                item4 = item4.getPrevious();
                ++n;
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class PositionType
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            Item item2 = item.getItemAs("SylStructure");
            String string = item2 == null ? "single" : (item2.getNext() == null ? (item2.getPrevious() == null ? "single" : "final") : (item2.getPrevious() == null ? "initial" : "mid"));
            return string;
        }
    }

    public static class PosInSyl
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = -1;
            Item item2 = item.getItemAs("SylStructure");
            while (item2 != null) {
                ++n;
                item2 = item2.getPrevious();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class LastAccent
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("Syllable");
            while (item2 != null) {
                if (FeatureProcessors.isAccented(item2)) break;
                item2 = item2.getPrevious();
                ++n;
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class Accented
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            if (FeatureProcessors.isAccented(item)) {
                return "1";
            }
            return "0";
        }
    }

    public static class TokenPosGuess
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            String string = item.getFeatures().getString("name");
            String string2 = string.toLowerCase();
            if (DIGITS_PATTERN.matcher(string2).matches()) {
                return "numeric";
            }
            if (DOUBLE_PATTERN.matcher(string2).matches()) {
                return "number";
            }
            if (months.contains(string2)) {
                return "month";
            }
            if (days.contains(string2)) {
                return "day";
            }
            if (string2.equals("a")) {
                return "a";
            }
            if (string2.equals("flight")) {
                return "flight";
            }
            if (string2.equals("to")) {
                return "to";
            }
            return "_other_";
        }
    }

    public static class MonthRange
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = Integer.parseInt(item.getFeatures().getString("name"));
            if (n > 0 && n < 32) {
                return "1";
            }
            return "0";
        }
    }

    public static class NumDigits
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            String string = item.getFeatures().getString("name");
            return Integer.toString(FeatureProcessors.rail(string.length()));
        }
    }

    public static class StressedSylOut
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("Syllable");
            Item item3 = LAST_SYLLABLE_PATH.findItem(item);
            Item item4 = item2.getNext();
            while (item4 != null) {
                if ("1".equals(item4.getFeatures().getString("stress"))) {
                    ++n;
                }
                if (item4.equalsShared(item3)) break;
                item4 = item4.getNext();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class StressedSylIn
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("Syllable");
            Item item3 = FIRST_SYLLABLE_PATH.findItem(item);
            Item item4 = item2.getPrevious();
            while (item4 != null && !item4.equalsShared(item3)) {
                if ("1".equals(item4.getFeatures().getString("stress"))) {
                    ++n;
                }
                item4 = item4.getPrevious();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class AccentedSylIn
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("Syllable");
            Item item3 = FIRST_SYLLABLE_PATH.findItem(item);
            Item item4 = item2;
            while (item4 != null) {
                if (FeatureProcessors.isAccented(item4)) {
                    ++n;
                }
                if (item4.equalsShared(item3)) break;
                item4 = item4.getPrevious();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class WordNumSyls
    implements FeatureProcessor {
        public String process(Item item) throws ProcessException {
            int n = 0;
            Item item2 = item.getItemAs("SylStructure").getDaughter();
            while (item2 != null) {
                ++n;
                item2 = item2.getNext();
            }
            return Integer.toString(FeatureProcessors.rail(n));
        }
    }

    public static class Gpos
    implements FeatureProcessor {
        PartOfSpeech pos;

        public Gpos(PartOfSpeech partOfSpeech) {
            this.pos = partOfSpeech;
        }

        public String process(Item item) throws ProcessException {
            return this.pos.getPartOfSpeech(item.toString());
        }
    }
}

