/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.en.F0ModelTerm;
import com.sun.speech.freetts.en.Interceptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ContourGenerator
implements UtteranceProcessor {
    private static final PathExtractor endPath;
    private static final PathExtractor lastDaughterEndPath;
    private static final PathExtractor postBreakPath;
    private static final PathExtractor preBreakPath;
    private static final PathExtractor vowelMidPath;
    private static final PathExtractor localF0Shift;
    private static final PathExtractor localF0Range;
    private final float modelMean;
    private final float modelStddev;
    private F0ModelTerm[] terms = new F0ModelTerm[]{null};
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$speech$freetts$en$ContourGenerator;

    public ContourGenerator(URL uRL, float f, float f2) throws IOException {
        this.modelMean = f;
        this.modelStddev = f2;
        ArrayList arrayList = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.startsWith("***")) {
                this.parseAndAdd(arrayList, string);
            }
            string = bufferedReader.readLine();
        }
        this.terms = arrayList.toArray(this.terms);
        bufferedReader.close();
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        Object object;
        Object object2;
        Object object3;
        float f = 0.0f;
        if (!$assertionsDisabled && utterance.getRelation("SylStructure") == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && utterance.getRelation("Syllable") == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && utterance.getRelation("Target") != null) {
            throw new AssertionError();
        }
        float f2 = utterance.getVoice().getPitch();
        f2 *= utterance.getVoice().getPitchShift();
        float f3 = utterance.getVoice().getPitchRange();
        Relation relation = utterance.createRelation("Target");
        Item item = utterance.getRelation("Syllable").getHead();
        while (item != null) {
            if (item.getItemAs("SylStructure").hasDaughters()) {
                Object object4 = localF0Shift.findFeature(item);
                float f4 = Float.parseFloat(object4.toString());
                f4 = (double)f4 == 0.0 ? f2 : (f4 *= f2);
                object4 = localF0Range.findFeature(item);
                float f5 = Float.parseFloat(object4.toString());
                if ((double)f5 == 0.0) {
                    f5 = f3;
                }
                object3 = this.applyLrModel(item);
                if (this.isPostBreak(item)) {
                    f = this.mapF0(((Interceptor)object3).start, f4, f5);
                }
                object2 = (Float)endPath.findFeature(item);
                this.addTargetPoint(relation, ((Float)object2).floatValue(), this.mapF0((((Interceptor)object3).start + f) / 2.0f, f4, f5));
                this.addTargetPoint(relation, this.vowelMid(item), this.mapF0(((Interceptor)object3).mid, f4, f5));
                f = this.mapF0(((Interceptor)object3).end, f4, f5);
                if (this.isPreBreak(item)) {
                    object = (Float)lastDaughterEndPath.findFeature(item);
                    this.addTargetPoint(relation, ((Float)object).floatValue(), this.mapF0(((Interceptor)object3).end, f4, f5));
                }
            }
            item = item.getNext();
        }
        if (utterance.getRelation("Segment").getHead() != null) {
            object3 = relation.getHead();
            if (object3 == null) {
                this.addTargetPoint(relation, 0.0f, f2);
            } else if (((Item)object3).getFeatures().getFloat("pos") > 0.0f) {
                object2 = ((Item)object3).prependItem(null);
                ((Item)object2).getFeatures().setFloat("pos", 0.0f);
                ((Item)object2).getFeatures().setFloat("f0", ((Item)object3).getFeatures().getFloat("f0"));
            }
            object2 = relation.getTail();
            object = utterance.getRelation("Segment").getTail();
            float f6 = 0.0f;
            if (object != null) {
                f6 = ((Item)object).getFeatures().getFloat("end");
            }
            if (((Item)object2).getFeatures().getFloat("pos") < f6) {
                this.addTargetPoint(relation, f6, ((Item)object2).getFeatures().getFloat("f0"));
            }
        }
    }

    private Interceptor applyLrModel(Item item) {
        float f = 0.0f;
        Interceptor interceptor = new Interceptor();
        interceptor.start = this.terms[0].start;
        interceptor.mid = this.terms[0].mid;
        interceptor.end = this.terms[0].end;
        int n = 1;
        while (n < this.terms.length) {
            Object object = this.terms[n].findFeature(item);
            f = this.terms[n].type != null ? (object.toString().equals(this.terms[n].type) ? 1.0f : 0.0f) : Float.parseFloat(object.toString());
            interceptor.start += f * this.terms[n].start;
            interceptor.mid += f * this.terms[n].mid;
            interceptor.end += f * this.terms[n].end;
            ++n;
        }
        return interceptor;
    }

    private final float vowelMid(Item item) {
        Item item2;
        Voice voice = item.getUtterance().getVoice();
        Item item3 = item2 = item.getItemAs("SylStructure").getDaughter();
        while (item3 != null) {
            if ("+".equals(voice.getPhoneFeature(item3.toString(), "vc"))) {
                float f = (item3.getFeatures().getFloat("end") + ((Float)vowelMidPath.findFeature(item3)).floatValue()) / 2.0f;
                return f;
            }
            item3 = item3.getNext();
        }
        float f = item2 == null ? 0.0f : (item2.getFeatures().getFloat("end") + ((Float)vowelMidPath.findFeature(item2)).floatValue()) / 2.0f;
        return f;
    }

    private void addTargetPoint(Relation relation, float f, float f2) {
        Item item = relation.appendItem();
        item.getFeatures().setFloat("pos", f);
        if ((double)f2 > 500.0) {
            item.getFeatures().setFloat("f0", 500.0f);
        } else if ((double)f2 < 50.0) {
            item.getFeatures().setFloat("f0", 50.0f);
        } else {
            item.getFeatures().setFloat("f0", f2);
        }
    }

    private final boolean isPostBreak(Item item) {
        return item.getPrevious() == null || "pau".equals(postBreakPath.findFeature(item));
    }

    private final boolean isPreBreak(Item item) {
        return item.getNext() == null || "pau".equals(preBreakPath.findFeature(item));
    }

    private final float mapF0(float f, float f2, float f3) {
        return (f - this.modelMean) / this.modelStddev * f3 + f2;
    }

    protected void parseAndAdd(List list, String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("null")) {
                string3 = null;
            }
            list.add(new F0ModelTerm(string2, f, f2, f3, string3));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Error("ContourGenerator: Error while parsing F0ModelTerm " + noSuchElementException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("ContourGenerator: Bad float format " + numberFormatException.getMessage());
        }
    }

    public String toString() {
        return "ContourGenerator";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$speech$freetts$en$ContourGenerator == null ? (class$com$sun$speech$freetts$en$ContourGenerator = ContourGenerator.class$("com.sun.speech.freetts.en.ContourGenerator")) : class$com$sun$speech$freetts$en$ContourGenerator).desiredAssertionStatus();
        endPath = new PathExtractorImpl("R:SylStructure.daughter.R:Segment.p.end", true);
        lastDaughterEndPath = new PathExtractorImpl("R:SylStructure.daughtern.end", true);
        postBreakPath = new PathExtractorImpl("R:SylStructure.daughter.R:Segment.p.name", true);
        preBreakPath = new PathExtractorImpl("R:SylStructure.daughtern.R:Segment.n.name", true);
        vowelMidPath = new PathExtractorImpl("R:Segment.p.end", true);
        localF0Shift = new PathExtractorImpl("R:SylStructure.parent.R:Token.parent.local_f0_shift", true);
        localF0Range = new PathExtractorImpl("R:SylStructure.parent.R:Token.parent.local_f0_range", true);
    }
}

