/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.clunits;

import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.cart.CARTImpl;
import com.sun.speech.freetts.clunits.UnitType;
import com.sun.speech.freetts.relp.SampleInfo;
import com.sun.speech.freetts.relp.SampleSet;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ClusterUnitDatabase {
    static final int CLUNIT_NONE = 65535;
    private DatabaseClusterUnit[] units;
    private UnitType[] unitTypes;
    private SampleSet sts;
    private SampleSet mcep;
    private int continuityWeight;
    private int optimalCoupling;
    private int extendSelections;
    private int joinMethod;
    private int[] joinWeights;
    private int joinWeightShift;
    private Map cartMap = new HashMap();
    private CART defaultCart = null;
    private transient List unitList;
    private transient int lineCount;
    private transient List unitTypesList;
    private static final int MAGIC = -255144934;
    private static final int VERSION = 4096;

    ClusterUnitDatabase(URL uRL, boolean bl) throws IOException {
        BulkTimer.LOAD.start("ClusterUnitDatabase");
        InputStream inputStream = Utilities.getInputStream(uRL);
        if (bl) {
            this.loadBinary(inputStream);
        } else {
            this.loadText(inputStream);
        }
        inputStream.close();
        BulkTimer.LOAD.stop("ClusterUnitDatabase");
    }

    int getStart(int n) {
        return this.units[n].start;
    }

    int getEnd(int n) {
        return this.units[n].end;
    }

    int getPhone(int n) {
        return this.units[n].phone;
    }

    CART getTree(String string) {
        CART cART = (CART)this.cartMap.get(string);
        if (cART == null) {
            System.err.println("ClusterUnitDatabase: can't find tree for " + string);
            return this.defaultCart;
        }
        return cART;
    }

    int getUnitTypeIndex(String string) {
        int n = 0;
        int n2 = this.unitTypes.length;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            int n4 = this.unitTypes[n3].getName().compareTo(string);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return -1;
    }

    int getUnitIndex(String string, int n) {
        int n2 = this.getUnitTypeIndex(string);
        if (n2 == -1) {
            this.error("getUnitIndex: can't find unit type " + string);
            n2 = 0;
        }
        if (n >= this.unitTypes[n2].getCount()) {
            this.error("getUnitIndex: can't find instance " + n + " of " + string);
            n = 0;
        }
        return this.unitTypes[n2].getStart() + n;
    }

    int getUnitIndexName(String string) {
        int n = string.lastIndexOf(95);
        if (n == -1) {
            this.error("getUnitIndexName: bad unit name " + string);
            return -1;
        }
        int n2 = Integer.parseInt(string.substring(n + 1));
        String string2 = string.substring(0, n);
        return this.getUnitIndex(string2, n2);
    }

    int getExtendSelections() {
        return this.extendSelections;
    }

    int getNextUnit(int n) {
        return this.units[n].next;
    }

    int getPrevUnit(int n) {
        return this.units[n].prev;
    }

    boolean isUnitTypeEqual(int n, int n2) {
        return this.units[n].type == this.units[n2].type;
    }

    int getOptimalCoupling() {
        return this.optimalCoupling;
    }

    int getContinuityWeight() {
        return this.continuityWeight;
    }

    int[] getJoinWeights() {
        return this.joinWeights;
    }

    DatabaseClusterUnit getUnit(String string) {
        return null;
    }

    DatabaseClusterUnit getUnit(int n) {
        return this.units[n];
    }

    String getName() {
        return "ClusterUnitDatabase";
    }

    SampleInfo getSampleInfo() {
        return this.sts.getSampleInfo();
    }

    SampleSet getSts() {
        return this.sts;
    }

    SampleSet getMcep() {
        return this.mcep;
    }

    int getJoinWeightShift() {
        return this.joinWeightShift;
    }

    private int calcJoinWeightShift(int[] nArray) {
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] != n) {
                return 0;
            }
            ++n2;
        }
        int n3 = 65536 / n;
        if (n3 == 2) {
            return 1;
        }
        if (n3 == 4) {
            return 2;
        }
        return 0;
    }

    private void loadText(InputStream inputStream) {
        this.unitList = new ArrayList();
        this.unitTypesList = new ArrayList();
        if (inputStream == null) {
            throw new Error("Can't load cluster db file.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            try {
                String string = bufferedReader.readLine();
                ++this.lineCount;
                while (string != null) {
                    if (!string.startsWith("***")) {
                        this.parseAndAdd(string, bufferedReader);
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                this.units = new DatabaseClusterUnit[this.unitList.size()];
                this.units = this.unitList.toArray(this.units);
                this.unitList = null;
                this.unitTypes = new UnitType[this.unitTypesList.size()];
                this.unitTypes = this.unitTypesList.toArray(this.unitTypes);
                this.unitTypesList = null;
            }
            catch (IOException iOException) {
                throw new Error(iOException.getMessage() + " at line " + this.lineCount);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    private void parseAndAdd(String string, BufferedReader bufferedReader) throws IOException {
        block16: {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("CONTINUITY_WEIGHT")) {
                    this.continuityWeight = Integer.parseInt(stringTokenizer.nextToken());
                    break block16;
                }
                if (string2.equals("OPTIMAL_COUPLING")) {
                    this.optimalCoupling = Integer.parseInt(stringTokenizer.nextToken());
                    break block16;
                }
                if (string2.equals("EXTEND_SELECTIONS")) {
                    this.extendSelections = Integer.parseInt(stringTokenizer.nextToken());
                    break block16;
                }
                if (string2.equals("JOIN_METHOD")) {
                    this.joinMethod = Integer.parseInt(stringTokenizer.nextToken());
                    break block16;
                }
                if (string2.equals("JOIN_WEIGHTS")) {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    this.joinWeights = new int[n];
                    int n2 = 0;
                    while (n2 < n) {
                        this.joinWeights[n2] = Integer.parseInt(stringTokenizer.nextToken());
                        ++n2;
                    }
                    this.joinWeightShift = this.calcJoinWeightShift(this.joinWeights);
                    break block16;
                }
                if (string2.equals("STS")) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals("STS")) {
                        this.sts = new SampleSet(stringTokenizer, bufferedReader);
                    } else {
                        this.mcep = new SampleSet(stringTokenizer, bufferedReader);
                    }
                    break block16;
                }
                if (string2.equals("UNITS")) {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    int n6 = Integer.parseInt(stringTokenizer.nextToken());
                    int n7 = Integer.parseInt(stringTokenizer.nextToken());
                    DatabaseClusterUnit databaseClusterUnit = new DatabaseClusterUnit(n, n3, n4, n5, n6, n7);
                    this.unitList.add(databaseClusterUnit);
                    break block16;
                }
                if (string2.equals("CART")) {
                    String string4 = stringTokenizer.nextToken();
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    CARTImpl cARTImpl = new CARTImpl(bufferedReader, n);
                    this.cartMap.put(string4, cARTImpl);
                    if (this.defaultCart == null) {
                        this.defaultCart = cARTImpl;
                    }
                    break block16;
                }
                if (string2.equals("UNIT_TYPE")) {
                    String string5 = stringTokenizer.nextToken();
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n8 = Integer.parseInt(stringTokenizer.nextToken());
                    UnitType unitType = new UnitType(string5, n, n8);
                    this.unitTypesList.add(unitType);
                    break block16;
                }
                throw new Error("Unsupported tag " + string2);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new Error("Error parsing db " + noSuchElementException.getMessage());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error("Error parsing numbers in db " + numberFormatException.getMessage());
            }
        }
    }

    private void loadBinary(InputStream inputStream) throws IOException {
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
            mappedByteBuffer.load();
            this.loadBinary(mappedByteBuffer);
            inputStream.close();
        } else {
            this.loadBinary(new DataInputStream(inputStream));
        }
    }

    private void loadBinary(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.getInt() != -255144934) {
            throw new Error("Bad magic in db");
        }
        if (byteBuffer.getInt() != 4096) {
            throw new Error("Bad VERSION in db");
        }
        this.continuityWeight = byteBuffer.getInt();
        this.optimalCoupling = byteBuffer.getInt();
        this.extendSelections = byteBuffer.getInt();
        this.joinMethod = byteBuffer.getInt();
        this.joinWeightShift = byteBuffer.getInt();
        int n = byteBuffer.getInt();
        this.joinWeights = new int[n];
        int n2 = 0;
        while (n2 < this.joinWeights.length) {
            this.joinWeights[n2] = byteBuffer.getInt();
            ++n2;
        }
        int n3 = byteBuffer.getInt();
        this.units = new DatabaseClusterUnit[n3];
        int n4 = 0;
        while (n4 < this.units.length) {
            this.units[n4] = new DatabaseClusterUnit(byteBuffer);
            ++n4;
        }
        int n5 = byteBuffer.getInt();
        this.unitTypes = new UnitType[n5];
        int n6 = 0;
        while (n6 < this.unitTypes.length) {
            this.unitTypes[n6] = new UnitType(byteBuffer);
            ++n6;
        }
        this.sts = new SampleSet(byteBuffer);
        this.mcep = new SampleSet(byteBuffer);
        int n7 = byteBuffer.getInt();
        this.cartMap = new HashMap();
        int n8 = 0;
        while (n8 < n7) {
            String string = Utilities.getString(byteBuffer);
            CART cART = CARTImpl.loadBinary(byteBuffer);
            this.cartMap.put(string, cART);
            if (this.defaultCart == null) {
                this.defaultCart = cART;
            }
            ++n8;
        }
    }

    private void loadBinary(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readInt() != -255144934) {
            throw new Error("Bad magic in db");
        }
        if (dataInputStream.readInt() != 4096) {
            throw new Error("Bad VERSION in db");
        }
        this.continuityWeight = dataInputStream.readInt();
        this.optimalCoupling = dataInputStream.readInt();
        this.extendSelections = dataInputStream.readInt();
        this.joinMethod = dataInputStream.readInt();
        this.joinWeightShift = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.joinWeights = new int[n];
        int n2 = 0;
        while (n2 < this.joinWeights.length) {
            this.joinWeights[n2] = dataInputStream.readInt();
            ++n2;
        }
        int n3 = dataInputStream.readInt();
        this.units = new DatabaseClusterUnit[n3];
        int n4 = 0;
        while (n4 < this.units.length) {
            this.units[n4] = new DatabaseClusterUnit(dataInputStream);
            ++n4;
        }
        int n5 = dataInputStream.readInt();
        this.unitTypes = new UnitType[n5];
        int n6 = 0;
        while (n6 < this.unitTypes.length) {
            this.unitTypes[n6] = new UnitType(dataInputStream);
            ++n6;
        }
        this.sts = new SampleSet(dataInputStream);
        this.mcep = new SampleSet(dataInputStream);
        int n7 = dataInputStream.readInt();
        this.cartMap = new HashMap();
        int n8 = 0;
        while (n8 < n7) {
            String string = Utilities.getString(dataInputStream);
            CART cART = CARTImpl.loadBinary(dataInputStream);
            this.cartMap.put(string, cART);
            if (this.defaultCart == null) {
                this.defaultCart = cART;
            }
            ++n8;
        }
    }

    void dumpBinary(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            dataOutputStream.writeInt(-255144934);
            dataOutputStream.writeInt(4096);
            dataOutputStream.writeInt(this.continuityWeight);
            dataOutputStream.writeInt(this.optimalCoupling);
            dataOutputStream.writeInt(this.extendSelections);
            dataOutputStream.writeInt(this.joinMethod);
            dataOutputStream.writeInt(this.joinWeightShift);
            dataOutputStream.writeInt(this.joinWeights.length);
            int n = 0;
            while (n < this.joinWeights.length) {
                dataOutputStream.writeInt(this.joinWeights[n]);
                ++n;
            }
            dataOutputStream.writeInt(this.units.length);
            int n2 = 0;
            while (n2 < this.units.length) {
                this.units[n2].dumpBinary(dataOutputStream);
                ++n2;
            }
            dataOutputStream.writeInt(this.unitTypes.length);
            int n3 = 0;
            while (n3 < this.unitTypes.length) {
                this.unitTypes[n3].dumpBinary(dataOutputStream);
                ++n3;
            }
            this.sts.dumpBinary(dataOutputStream);
            this.mcep.dumpBinary(dataOutputStream);
            dataOutputStream.writeInt(this.cartMap.size());
            Iterator iterator = this.cartMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                CART cART = (CART)this.cartMap.get(string2);
                Utilities.outString(dataOutputStream, string2);
                cART.dumpBinary(dataOutputStream);
            }
            dataOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error("Can't dump binary database " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("Can't write binary database " + iOException.getMessage());
        }
    }

    public boolean compare(ClusterUnitDatabase clusterUnitDatabase) {
        System.out.println("Warning: Compare not implemented yet");
        return false;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            if (stringArray.length > 0) {
                BulkTimer bulkTimer = new BulkTimer();
                bulkTimer.start();
                int n = 0;
                while (n < stringArray.length) {
                    ClusterUnitDatabase clusterUnitDatabase;
                    if (stringArray[n].equals("-generate_binary")) {
                        bulkTimer.start("load_text");
                        clusterUnitDatabase = new ClusterUnitDatabase(new URL("file:./cmu_time_awb.txt"), false);
                        bulkTimer.stop("load_text");
                        bulkTimer.start("dump_binary");
                        clusterUnitDatabase.dumpBinary("cmu_time_awb.bin");
                        bulkTimer.stop("dump_binary");
                    } else if (stringArray[n].equals("-compare")) {
                        bulkTimer.start("load_text");
                        clusterUnitDatabase = new ClusterUnitDatabase(new URL("file:./cmu_time_awb.txt"), false);
                        bulkTimer.stop("load_text");
                        bulkTimer.start("load_binary");
                        ClusterUnitDatabase clusterUnitDatabase2 = new ClusterUnitDatabase(new URL("file:./cmu_time_awb.bin"), true);
                        bulkTimer.stop("load_binary");
                        bulkTimer.start("compare");
                        if (clusterUnitDatabase.compare(clusterUnitDatabase2)) {
                            System.out.println("other compare ok");
                        } else {
                            System.out.println("other compare different");
                        }
                        bulkTimer.stop("compare");
                    } else if (stringArray[n].equals("-showtimes")) {
                        bl = true;
                    } else {
                        System.out.println("Unknown option " + stringArray[n]);
                    }
                    ++n;
                }
                bulkTimer.stop();
                if (bl) {
                    bulkTimer.show("ClusterUnitDatabase");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showTimes");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private void error(String string) {
        System.out.println("ClusterUnitDatabase Error: " + string);
    }

    class DatabaseClusterUnit {
        int type;
        int phone;
        int start;
        int end;
        int prev;
        int next;

        DatabaseClusterUnit(int n, int n2, int n3, int n4, int n5, int n6) {
            this.type = n;
            this.phone = n2;
            this.start = n3;
            this.end = n4;
            this.prev = n5;
            this.next = n6;
        }

        DatabaseClusterUnit(ByteBuffer byteBuffer) throws IOException {
            this.type = byteBuffer.getInt();
            this.phone = byteBuffer.getInt();
            this.start = byteBuffer.getInt();
            this.end = byteBuffer.getInt();
            this.prev = byteBuffer.getInt();
            this.next = byteBuffer.getInt();
        }

        DatabaseClusterUnit(DataInputStream dataInputStream) throws IOException {
            this.type = dataInputStream.readInt();
            this.phone = dataInputStream.readInt();
            this.start = dataInputStream.readInt();
            this.end = dataInputStream.readInt();
            this.prev = dataInputStream.readInt();
            this.next = dataInputStream.readInt();
        }

        String getName() {
            return ClusterUnitDatabase.this.unitTypes[this.type].getName();
        }

        void dumpBinary(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.type);
            dataOutputStream.writeInt(this.phone);
            dataOutputStream.writeInt(this.start);
            dataOutputStream.writeInt(this.end);
            dataOutputStream.writeInt(this.prev);
            dataOutputStream.writeInt(this.next);
        }
    }
}

