/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.cart;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.PhoneDuration;
import com.sun.speech.freetts.PhoneDurations;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;

public class Durator
implements UtteranceProcessor {
    private float meanRate;
    protected CART cart;
    protected PhoneDurations durations;
    private static final PathExtractor DURATION_STRETCH_PATH = new PathExtractorImpl("R:SylStructure.parent.parent.R:Token.parent.local_duration_stretch", true);

    public Durator(CART cART, float f, PhoneDurations phoneDurations) {
        this.cart = cART;
        this.meanRate = f;
        this.durations = phoneDurations;
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        float f = utterance.getVoice().getDurationStretch();
        float f2 = 0.0f;
        float f3 = this.meanRate / utterance.getVoice().getRate();
        Item item = utterance.getRelation("Segment").getHead();
        while (item != null) {
            float f4 = ((Float)this.cart.interpret(item)).floatValue();
            PhoneDuration phoneDuration = this.durations.getPhoneDuration(item.getFeatures().getString("name"));
            Object object = DURATION_STRETCH_PATH.findFeature(item);
            float f5 = Float.parseFloat(object.toString());
            f5 = (double)f5 == 0.0 ? f : (f5 *= f);
            float f6 = f5 * (f4 * phoneDuration.getStandardDeviation() + phoneDuration.getMean());
            item.getFeatures().setFloat("end", f2 += f6);
            item = item.getNext();
        }
    }

    public String toString() {
        return "CARTDurator";
    }
}

