/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.ValidationException;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.en.us.CMUDiphoneVoice;
import com.sun.speech.freetts.en.us.CMUVoice;
import de.dfki.lt.freetts.en.us.MbrolaVoice;
import de.dfki.lt.freetts.en.us.MbrolaVoiceUS1;
import de.dfki.lt.freetts.en.us.MbrolaVoiceUS2;
import de.dfki.lt.freetts.en.us.MbrolaVoiceUS3;
import de.dfki.lt.freetts.en.us.MbrolaVoiceValidator;

class VoiceManager {
    private String[] voices = new String[]{"kevin", "kevin16", "mbrola1", "mbrola2", "mbrola3"};

    public boolean contains(String string) {
        int n = 0;
        while (n < this.voices.length) {
            if (this.voices[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.voices.length) {
            if (this.voices.length > 1) {
                if (n != 0) {
                    string = string + ", ";
                }
                if (n + 1 == this.voices.length) {
                    string = string + "or ";
                }
            }
            string = string + this.voices[n];
            ++n;
        }
        return string;
    }

    public Voice getVoice(String string) throws IllegalStateException {
        CMUVoice cMUVoice = null;
        boolean bl = true;
        if (string.equals("kevin")) {
            cMUVoice = new CMUDiphoneVoice(bl);
            cMUVoice.getFeatures().setString("databaseName", "cmu_kal/diphone_units.bin");
        } else if (string.equals("kevin16")) {
            cMUVoice = new CMUDiphoneVoice(bl);
            cMUVoice.getFeatures().setString("databaseName", "cmu_kal/diphone_units16.bin");
        } else if (string.startsWith("mbrola")) {
            if (string.equals("mbrola1")) {
                cMUVoice = new MbrolaVoiceUS1(bl);
            } else if (string.equals("mbrola2")) {
                cMUVoice = new MbrolaVoiceUS2(bl);
            } else if (string.equals("mbrola3")) {
                cMUVoice = new MbrolaVoiceUS3(bl);
            }
            if (cMUVoice != null) {
                MbrolaVoiceValidator mbrolaVoiceValidator = new MbrolaVoiceValidator((MbrolaVoice)cMUVoice);
                try {
                    mbrolaVoiceValidator.validate();
                }
                catch (ValidationException validationException) {
                    System.err.println(validationException.getMessage());
                    throw new IllegalStateException("Problem starting MBROLA voice");
                }
            }
        }
        return cMUVoice;
    }
}

