/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.speech.synthesis.JSMLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSMLParser {
    Document document;

    public JSMLParser(String string, boolean bl) throws JSMLException {
        if (!string.substring(0, 2).equals("<?")) {
            string = "<jsml>\n" + string + "</jsml>\n";
        }
        try {
            this.document = this.parse(new InputSource(new StringReader(string)), bl);
        }
        catch (IOException iOException) {
            throw new JSMLException("JSMLParser: " + iOException.getMessage());
        }
    }

    public JSMLParser(URL uRL, boolean bl) throws JSMLException, IOException {
        this.document = this.parse(new InputSource(uRL.openStream()), bl);
    }

    public Document getDocument() {
        return this.document;
    }

    protected Document parse(InputSource inputSource, boolean bl) throws JSMLException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        documentBuilderFactory.setValidating(bl);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setExpandEntityReferences(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JSMLException("JSMLParser: " + parserConfigurationException.getMessage());
        }
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JSMLException("JSMLParser: " + sAXException.getMessage());
        }
        return document;
    }
}

