/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import com.sun.speech.engine.synthesis.BaseSynthesizer;
import com.sun.speech.engine.synthesis.JSMLParser;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import javax.speech.SpeechEvent;
import javax.speech.synthesis.JSMLException;
import javax.speech.synthesis.Speakable;
import javax.speech.synthesis.SpeakableEvent;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.SynthesizerQueueItem;
import org.w3c.dom.Document;

public class BaseSynthesizerQueueItem
extends SynthesizerQueueItem
implements SpeechEventDispatcher {
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private Document document = null;
    protected static int itemNumber = 0;
    protected int thisItemNumber = itemNumber++;
    protected BaseSynthesizer synth;

    public BaseSynthesizerQueueItem() {
        super(null, null, false, null);
    }

    protected void setData(BaseSynthesizer baseSynthesizer, Speakable speakable, SpeakableListener speakableListener) throws JSMLException {
        this.synth = baseSynthesizer;
        this.source = speakable;
        this.text = speakable.getJSMLText();
        this.plainText = false;
        this.listener = speakableListener;
        this.document = new JSMLParser(this.text, false).getDocument();
    }

    protected void setData(BaseSynthesizer baseSynthesizer, String string, boolean bl, SpeakableListener speakableListener) throws JSMLException {
        this.synth = baseSynthesizer;
        this.source = string;
        this.text = string;
        this.plainText = bl;
        this.listener = speakableListener;
        if (!bl) {
            this.document = new JSMLParser(this.text, false).getDocument();
        }
    }

    protected void setData(BaseSynthesizer baseSynthesizer, URL uRL, SpeakableListener speakableListener) throws JSMLException, IOException {
        this.synth = baseSynthesizer;
        this.source = uRL;
        this.text = null;
        this.plainText = false;
        this.listener = speakableListener;
        this.document = new JSMLParser(uRL, false).getDocument();
    }

    protected Document getDocument() {
        return this.document;
    }

    protected synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isCompleted() {
        return this.done;
    }

    public synchronized boolean waitCompleted() {
        while (!this.isCompleted()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("FreeTTSSynthesizerQueueItem.Wait interrupted");
                return false;
            }
        }
        return !this.isCancelled();
    }

    public synchronized void cancelled() {
        this.postSpeakableCancelled();
        this.notifyAll();
    }

    public synchronized void completed() {
        this.postSpeakableEnded();
        this.notifyAll();
    }

    public void started() {
        this.postSpeakableStarted();
    }

    public int getItemNumber() {
        return this.thisItemNumber;
    }

    public void postMarkerReached(String string, int n) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 608, string, n));
    }

    public void fireMarkerReached(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.markerReached(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.markerReached(speakableEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSpeakableCancelled() {
        boolean bl;
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this;
        synchronized (baseSynthesizerQueueItem) {
            bl = !this.done;
            this.done = true;
            this.cancelled = true;
        }
        if (bl) {
            SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 606));
        }
    }

    public void fireSpeakableCancelled(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.speakableCancelled(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.speakableCancelled(speakableEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSpeakableEnded() {
        boolean bl;
        BaseSynthesizerQueueItem baseSynthesizerQueueItem = this;
        synchronized (baseSynthesizerQueueItem) {
            bl = !this.done;
            this.done = true;
        }
        if (bl) {
            SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 603));
        }
    }

    public void fireSpeakableEnded(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.speakableEnded(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.speakableEnded(speakableEvent);
            }
        }
    }

    public void postSpeakablePaused() {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 604));
    }

    public void fireSpeakablePaused(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.speakablePaused(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.speakablePaused(speakableEvent);
            }
        }
    }

    public void postSpeakableResumed() {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 605));
    }

    public void fireSpeakableResumed(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.speakableResumed(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.speakableResumed(speakableEvent);
            }
        }
    }

    public void postSpeakableStarted() {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 602));
    }

    public void fireSpeakableStarted(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.speakableStarted(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.speakableStarted(speakableEvent);
            }
        }
    }

    public void postTopOfQueue() {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 601));
    }

    public void fireTopOfQueue(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.topOfQueue(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.topOfQueue(speakableEvent);
            }
        }
    }

    public void postWordStarted(String string, int n, int n2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new SpeakableEvent(this.source, 607, string, n, n2));
    }

    public void fireWordStarted(SpeakableEvent speakableEvent) {
        if (this.listener != null) {
            this.listener.wordStarted(speakableEvent);
        }
        if (this.synth.speakableListeners != null) {
            Enumeration enumeration = this.synth.speakableListeners.elements();
            while (enumeration.hasMoreElements()) {
                SpeakableListener speakableListener = (SpeakableListener)enumeration.nextElement();
                speakableListener.wordStarted(speakableEvent);
            }
        }
    }

    public void dispatchSpeechEvent(SpeechEvent speechEvent) {
        switch (speechEvent.getId()) {
            case 608: {
                this.fireMarkerReached((SpeakableEvent)speechEvent);
                break;
            }
            case 606: {
                this.fireSpeakableCancelled((SpeakableEvent)speechEvent);
                break;
            }
            case 603: {
                this.fireSpeakableEnded((SpeakableEvent)speechEvent);
                break;
            }
            case 604: {
                this.fireSpeakablePaused((SpeakableEvent)speechEvent);
                break;
            }
            case 605: {
                this.fireSpeakableResumed((SpeakableEvent)speechEvent);
                break;
            }
            case 602: {
                this.fireSpeakableStarted((SpeakableEvent)speechEvent);
                break;
            }
            case 601: {
                this.fireTopOfQueue((SpeakableEvent)speechEvent);
                break;
            }
            case 607: {
                this.fireWordStarted((SpeakableEvent)speechEvent);
            }
        }
    }
}

