/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.EngineEventPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Date;
import javax.speech.Engine;
import javax.speech.EngineErrorEvent;
import javax.speech.EngineEvent;
import javax.speech.EngineListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EngineMonitor {
    protected Engine engine;
    protected EngineListener engineListener;
    protected EngineEventPanel eventPanel;
    protected JPanel statePanel;
    protected JLabel deallocatedLabel;
    protected JLabel allocatingResourcesLabel;
    protected JLabel allocatedLabel;
    protected JLabel deallocatingResourcesLabel;
    protected JLabel pausedLabel;
    protected JLabel resumedLabel;

    public EngineMonitor(Engine engine) {
        this.engine = engine;
        this.engine.addEngineListener(this.getEngineListener());
    }

    protected EngineListener getEngineListener() {
        if (this.engineListener == null) {
            this.engineListener = new EngineMonitorEngineListener();
        }
        return this.engineListener;
    }

    public Component getEventPanel() {
        if (this.eventPanel == null) {
            this.eventPanel = new EngineEventPanel();
        }
        return this.eventPanel;
    }

    public Component getStatePanel() {
        if (this.statePanel == null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 2));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(4, 2));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Engine State:"));
            this.deallocatedLabel = new JLabel("DEALLOCATED");
            this.allocatingResourcesLabel = new JLabel("ALLOCATING_RESOURCES");
            this.allocatedLabel = new JLabel("ALLOCATED");
            this.deallocatingResourcesLabel = new JLabel("DEALLOCATING_RESOURCES");
            this.pausedLabel = new JLabel("PAUSED");
            this.resumedLabel = new JLabel("RESUMED");
            jPanel2.add(this.deallocatedLabel);
            jPanel2.add(this.pausedLabel);
            jPanel2.add(this.allocatedLabel);
            jPanel2.add(this.resumedLabel);
            jPanel2.add(this.deallocatingResourcesLabel);
            jPanel2.add(new JLabel(""));
            jPanel2.add(this.allocatingResourcesLabel);
            jPanel.add(jPanel2);
            this.statePanel = jPanel;
        }
        return this.statePanel;
    }

    protected void handleEvent(EngineEvent engineEvent) {
        if (this.eventPanel != null) {
            this.eventPanel.addText(new Date().toString() + ": " + engineEvent.toString() + "\n");
            this.eventPanel.addText("   Old state: " + this.engineStateString(engineEvent.getOldEngineState()) + "\n");
            this.eventPanel.addText("   New state: " + this.engineStateString(engineEvent.getNewEngineState()) + "\n");
        }
        this.updateGUIComponents();
    }

    protected void updateGUIComponents() {
        this.updateEngineStateComponents();
    }

    protected void updateEngineStateComponents() {
        if (this.statePanel != null) {
            this.deallocatedLabel.setEnabled(this.engine.testEngineState(1L));
            this.allocatingResourcesLabel.setEnabled(this.engine.testEngineState(2L));
            this.allocatedLabel.setEnabled(this.engine.testEngineState(4L));
            this.deallocatingResourcesLabel.setEnabled(this.engine.testEngineState(8L));
            this.pausedLabel.setEnabled(this.engine.testEngineState(256L));
            this.resumedLabel.setEnabled(this.engine.testEngineState(512L));
        }
    }

    protected String engineStateString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((l & 1L) != 0L) {
            this.appendBuffer(stringBuffer, "DEALLOCATED");
        }
        if ((l & 2L) != 0L) {
            this.appendBuffer(stringBuffer, "ALLOCATING_RESOURCES");
        }
        if ((l & 4L) != 0L) {
            this.appendBuffer(stringBuffer, "ALLOCATED");
        }
        if ((l & 8L) != 0L) {
            this.appendBuffer(stringBuffer, "DEALLOCATING_RESOURCES");
        }
        if ((l & 0x100L) != 0L) {
            this.appendBuffer(stringBuffer, "PAUSED");
        }
        if ((l & 0x200L) != 0L) {
            this.appendBuffer(stringBuffer, "RESUMED");
        }
        return stringBuffer.toString();
    }

    protected void appendBuffer(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(":");
        }
        stringBuffer.append(string);
    }

    protected class EngineMonitorEngineListener
    implements EngineListener {
        public void enginePaused(EngineEvent engineEvent) {
            EngineMonitor.this.handleEvent(engineEvent);
        }

        public void engineResumed(EngineEvent engineEvent) {
            EngineMonitor.this.handleEvent(engineEvent);
        }

        public void engineAllocated(EngineEvent engineEvent) {
            EngineMonitor.this.handleEvent(engineEvent);
        }

        public void engineDeallocated(EngineEvent engineEvent) {
            EngineMonitor.this.handleEvent(engineEvent);
        }

        public void engineAllocatingResources(EngineEvent engineEvent) {
            EngineMonitor.this.handleEvent(engineEvent);
        }

        public void engineDeallocatingResources(EngineEvent engineEvent) {
            EngineMonitor.this.handleEvent(engineEvent);
        }

        public void engineError(EngineErrorEvent engineErrorEvent) {
            EngineMonitor.this.handleEvent((EngineEvent)engineErrorEvent);
        }
    }
}

